/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.ImageProvider;

public class SourceButton {
    private int x = 0;
    private int y = 30;
    private int enlagedWidth = 200;
    private int enlargedHeight = 50;
    private ImageIcon enlargeImage = ImageProvider.get((String)"", (String)"layer-switcher-maximize.png");
    private ImageIcon shrinkImage = ImageProvider.get((String)"", (String)"layer-switcher-minimize.png");
    private ImageIcon imageMapnik = ImageProvider.get((String)"", (String)"blue_Mapnik.png");
    private ImageIcon imageOsmarender = ImageProvider.get((String)"", (String)"blue_Osmarender.png");
    private boolean isEnlarged = false;
    private boolean isMapnik = true;
    private static final String SOURCE_1 = "Osmarender";
    private static final String SOURCE_2 = "Mapnik";
    public static final int HIDE_OR_SHOW = 1;
    public static final int MAPNIK = 2;
    public static final int OSMARENDER = 3;

    public void paint(Graphics g) {
        if (this.isEnlarged) {
            if (this.isMapnik) {
                g.drawImage(this.imageMapnik.getImage(), g.getClipBounds().width - this.imageMapnik.getIconWidth(), this.y, null);
            } else {
                g.drawImage(this.imageOsmarender.getImage(), g.getClipBounds().width - this.imageMapnik.getIconWidth(), this.y, null);
            }
            if (this.shrinkImage != null) {
                this.x = g.getClipBounds().width - this.shrinkImage.getIconWidth();
                g.drawImage(this.shrinkImage.getImage(), this.x, this.y, null);
            }
        } else if (this.enlargeImage != null) {
            this.x = g.getClipBounds().width - this.enlargeImage.getIconWidth();
            g.drawImage(this.enlargeImage.getImage(), this.x, this.y, null);
        }
    }

    public void toggle() {
        this.isEnlarged = !this.isEnlarged;
    }

    public int hit(Point point) {
        if (this.isEnlarged) {
            if (this.x < point.x && point.x < this.x + this.shrinkImage.getIconWidth()) {
                if (this.y < point.y && point.y < this.y + this.shrinkImage.getIconHeight()) {
                    return 1;
                }
            } else if (this.x - this.imageMapnik.getIconWidth() < point.x && point.x < this.x) {
                if (this.y < point.y && point.y < this.y + this.imageMapnik.getIconHeight() / 2) {
                    this.isMapnik = false;
                    return 3;
                }
                if (this.y + this.imageMapnik.getIconHeight() / 2 < point.y && point.y < this.y + this.imageMapnik.getIconHeight()) {
                    this.isMapnik = true;
                    return 2;
                }
            }
        } else if (this.x < point.x && point.x < this.x + this.enlargeImage.getIconWidth() && this.y < point.y && point.y < this.y + this.enlargeImage.getIconHeight()) {
            return 1;
        }
        return 0;
    }
}

