// License: GPL. For details, see LICENSE file.
package org.openstreetmap.josm.gui.preferences.map;

import static org.junit.Assert.assertNotNull;

import org.junit.BeforeClass;
import org.junit.Test;
import org.openstreetmap.josm.JOSMFixture;
import org.openstreetmap.josm.gui.preferences.PreferencesTestUtils;

/**
 * Unit tests of {@link BackupPreference} class.
 */
public class BackupPreferenceTest {

    /**
     * Setup test.
     */
    @BeforeClass
    public static void setUpBeforeClass() {
        JOSMFixture.createUnitTestFixture().init();
    }

    /**
     * Unit test of {@link BackupPreference#BackupPreference}.
     */
    @Test
    public void testBackupPreference()  {
        assertNotNull(new BackupPreference.Factory().createPreferenceSetting());
    }

    /**
     * Unit test of {@link BackupPreference#addGui}.
     */
    @Test
    public void testAddGui() {
        PreferencesTestUtils.testPreferenceSettingAddGui(new BackupPreference.Factory(), MapPreference.class);
    }
}
