/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import at.dallermassl.josm.plugin.surveyor.ButtonDescription;
import at.dallermassl.josm.plugin.surveyor.GpsDataSource;
import at.dallermassl.josm.plugin.surveyor.SurveyorActionDescription;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import livegps.LiveGpsData;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

public class SurveyorComponent
extends JComponent
implements PropertyChangeListener,
GpsDataSource {
    private static final long serialVersionUID = 4539838472057529042L;
    private LiveGpsData gpsData;
    private int rows = 0;
    private int columns = 0;
    private int width = 0;
    private int height = 0;
    private JLabel streetLabel;
    private JPanel buttonPanel;
    private Set<String> hotKeys = new HashSet<String>();

    public SurveyorComponent() {
        this.setLayout(new BorderLayout());
        this.streetLabel = new JLabel("Way: ");
        float fontSize = Float.parseFloat(Main.pref.get("surveyor.way.fontsize", "35"));
        Main.pref.put("surveyor.way.fontsize", String.valueOf(fontSize));
        this.streetLabel.setFont(this.streetLabel.getFont().deriveFont(35.0f));
        this.add((Component)this.streetLabel, "North");
        this.buttonPanel = new JPanel();
        this.add((Component)this.buttonPanel, "Center");
    }

    public void setRows(String rowsString) {
        this.rows = Integer.parseInt(rowsString);
        this.buttonPanel.setLayout(new GridLayout(this.rows, this.columns));
    }

    public void setColumns(String columnsString) {
        System.out.println("setting columns to " + columnsString);
        this.columns = Integer.parseInt(columnsString);
        this.buttonPanel.setLayout(new GridLayout(this.rows, this.columns));
    }

    public void setWidth(String widthString) {
        this.width = Integer.parseInt(widthString);
        if (this.width > 0 && this.height > 0) {
            super.setPreferredSize(new Dimension(this.width, this.height));
        }
    }

    public void setHeight(String heightString) {
        this.height = Integer.parseInt(heightString);
        if (this.width > 0 && this.height > 0) {
            super.setPreferredSize(new Dimension(this.width, this.height));
        }
    }

    public void setGridSize(int rows, int cols) {
        this.setLayout(new GridLayout(rows, cols));
    }

    public void addButton(ButtonDescription description) {
        if (description.getHotkey() != "" && this.hotKeys.contains(description.getHotkey())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Duplicate hotkey for button '{0}' - button will be ignored!", (Object[])new Object[]{description.getLabel()}));
        } else {
            if (this.rows == 0 && this.columns == 0) {
                this.setColumns("4");
            }
            description.setGpsDataSource(this);
            this.buttonPanel.add(description.createComponent());
            this.hotKeys.add(description.getHotkey());
        }
    }

    public static void main(String[] args) {
        InputStreamReader in = new InputStreamReader(SurveyorComponent.class.getClassLoader().getResourceAsStream("surveyor.xml"));
        XmlObjectParser parser = new XmlObjectParser();
        parser.mapOnStart("surveyor", SurveyorComponent.class);
        parser.map("button", ButtonDescription.class);
        parser.map("action", SurveyorActionDescription.class);
        SurveyorComponent surveyorComponent = null;
        try {
            parser.start((Reader)in);
            ArrayList<SurveyorActionDescription> actions = new ArrayList<SurveyorActionDescription>();
            while (parser.hasNext()) {
                Object object = parser.next();
                if (object instanceof SurveyorComponent) {
                    System.out.println("SurveyorComponent " + object);
                    surveyorComponent = (SurveyorComponent)object;
                    continue;
                }
                if (object instanceof ButtonDescription) {
                    System.out.println("ButtonDescription " + object);
                    ((ButtonDescription)object).setActions(actions);
                    surveyorComponent.addButton((ButtonDescription)object);
                    actions.clear();
                    continue;
                }
                if (object instanceof SurveyorActionDescription) {
                    System.out.println("SurveyorActionDescription " + object);
                    actions.add((SurveyorActionDescription)object);
                    continue;
                }
                System.err.println("unknown " + object);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.add(surveyorComponent);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(2);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("gpsdata".equals(evt.getPropertyName())) {
            this.gpsData = (LiveGpsData)evt.getNewValue();
            this.streetLabel.setText("Way: " + this.gpsData.getWayInfo());
        }
    }

    public LiveGpsData getGpsData() {
        return this.gpsData;
    }
}

