/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.openstreetmap.josm.plugins.remotecontrol.RequestProcessor;

public class HttpServer
extends Thread {
    public static final int DEFAULT_PORT = 8111;
    private ServerSocket server;

    public HttpServer(int port) throws IOException {
        super("RemoteControl HTTP Server");
        this.setDaemon(true);
        this.server = new ServerSocket(port, 1, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
    }

    public void run() {
        System.out.println("RemoteControl::Accepting connections on port " + this.server.getLocalPort());
        while (true) {
            try {
                while (true) {
                    Socket request = this.server.accept();
                    RequestProcessor.processRequest(request);
                }
            }
            catch (SocketException se) {
                if (this.server.isClosed()) continue;
                se.printStackTrace();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        this.server.close();
    }
}

