/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CaseFormat;
import com.google.common.primitives.Ints;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocNodeImpl;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocLexer;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class AbstractJavadocCheck
extends Check {
    public static final String PARSE_ERROR_MESSAGE_KEY = "javadoc.parse.error";
    public static final String UNRECOGNIZED_ANTLR_ERROR_MESSAGE_KEY = "javadoc.unrecognized.antlr.error";
    static final String JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
    static final String JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
    private static final ThreadLocal<Map<String, ParseStatus>> TREE_CACHE = new ThreadLocal<Map<String, ParseStatus>>(){

        @Override
        protected Map<String, ParseStatus> initialValue() {
            return new HashMap<String, ParseStatus>();
        }
    };
    private DescriptiveErrorListener errorListener;
    private DetailAST blockCommentAst;

    public abstract int[] getDefaultJavadocTokens();

    public abstract void visitJavadocToken(DetailNode var1);

    public void beginJavadocTree(DetailNode rootAst) {
    }

    public void finishJavadocTree(DetailNode rootAst) {
    }

    public void leaveJavadocToken(DetailNode ast) {
    }

    @Override
    public final int[] getDefaultTokens() {
        return new int[]{145};
    }

    @Override
    public final boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public final void beginTree(DetailAST rootAST) {
        TREE_CACHE.get().clear();
    }

    @Override
    public final void finishTree(DetailAST rootAST) {
        TREE_CACHE.get().clear();
    }

    @Override
    public final void visitToken(DetailAST blockCommentNode) {
        if (JavadocUtils.isJavadocComment(blockCommentNode)) {
            ParseStatus result;
            this.blockCommentAst = blockCommentNode;
            String treeCacheKey = blockCommentNode.getLineNo() + ":" + blockCommentNode.getColumnNo();
            if (TREE_CACHE.get().containsKey(treeCacheKey)) {
                result = TREE_CACHE.get().get(treeCacheKey);
            } else {
                result = this.parseJavadocAsDetailNode(blockCommentNode);
                TREE_CACHE.get().put(treeCacheKey, result);
            }
            if (result.getParseErrorMessage() == null) {
                this.processTree(result.getTree());
            } else {
                ParseErrorMessage parseErrorMessage = result.getParseErrorMessage();
                this.log(parseErrorMessage.getLineNumber(), parseErrorMessage.getMessageKey(), parseErrorMessage.getMessageArguments());
            }
        }
    }

    protected DetailAST getBlockCommentAst() {
        return this.blockCommentAst;
    }

    private ParseStatus parseJavadocAsDetailNode(DetailAST javadocCommentAst) {
        String javadocComment = JavadocUtils.getJavadocCommentContent(javadocCommentAst);
        this.errorListener = new DescriptiveErrorListener();
        this.errorListener.setOffset(javadocCommentAst.getLineNo() - 1);
        ParseStatus result = new ParseStatus();
        try {
            ParseTree parseTree = this.parseJavadocAsParseTree(javadocComment);
            DetailNode tree = this.convertParseTreeToDetailNode(parseTree);
            result.setTree(tree);
        }
        catch (ParseCancellationException ex) {
            ParseErrorMessage parseErrorMessage = this.errorListener.getErrorMessage();
            if (parseErrorMessage == null) {
                parseErrorMessage = new ParseErrorMessage(javadocCommentAst.getLineNo(), UNRECOGNIZED_ANTLR_ERROR_MESSAGE_KEY, javadocCommentAst.getColumnNo(), ex.getMessage());
            }
            result.setParseErrorMessage(parseErrorMessage);
        }
        return result;
    }

    private DetailNode convertParseTreeToDetailNode(ParseTree parseTreeNode) {
        JavadocNodeImpl rootJavadocNode;
        JavadocNodeImpl currentJavadocParent = rootJavadocNode = this.createRootJavadocNode(parseTreeNode);
        ParseTree parseTreeParent = parseTreeNode;
        while (currentJavadocParent != null) {
            JavadocNodeImpl[] children = (JavadocNodeImpl[])currentJavadocParent.getChildren();
            this.insertChildrenNodes(children, parseTreeParent);
            if (children.length > 0) {
                currentJavadocParent = children[0];
                parseTreeParent = parseTreeParent.getChild(0);
                continue;
            }
            JavadocNodeImpl nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(currentJavadocParent);
            ParseTree nextParseTreeSibling = AbstractJavadocCheck.getNextSibling(parseTreeParent);
            if (nextJavadocSibling == null) {
                JavadocNodeImpl tempJavadocParent = (JavadocNodeImpl)currentJavadocParent.getParent();
                ParseTree tempParseTreeParent = parseTreeParent.getParent();
                while (nextJavadocSibling == null && tempJavadocParent != null) {
                    nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(tempJavadocParent);
                    nextParseTreeSibling = AbstractJavadocCheck.getNextSibling(tempParseTreeParent);
                    tempJavadocParent = (JavadocNodeImpl)tempJavadocParent.getParent();
                    tempParseTreeParent = tempParseTreeParent.getParent();
                }
            }
            currentJavadocParent = nextJavadocSibling;
            parseTreeParent = nextParseTreeSibling;
        }
        return rootJavadocNode;
    }

    private void insertChildrenNodes(JavadocNodeImpl[] nodes, ParseTree parseTreeParent) {
        for (int i = 0; i < nodes.length; ++i) {
            JavadocNodeImpl currentJavadocNode = nodes[i];
            ParseTree currentParseTreeNodeChild = parseTreeParent.getChild(i);
            DetailNode[] subChildren = this.createChildrenNodes(currentJavadocNode, currentParseTreeNodeChild);
            currentJavadocNode.setChildren(subChildren);
        }
    }

    private JavadocNodeImpl[] createChildrenNodes(JavadocNodeImpl parentJavadocNode, ParseTree parseTreeNode) {
        JavadocNodeImpl[] children = new JavadocNodeImpl[parseTreeNode.getChildCount()];
        for (int j = 0; j < children.length; ++j) {
            JavadocNodeImpl child;
            children[j] = child = this.createJavadocNode(parseTreeNode.getChild(j), parentJavadocNode, j);
        }
        return children;
    }

    private JavadocNodeImpl createRootJavadocNode(ParseTree parseTreeNode) {
        JavadocNodeImpl rootJavadocNode = this.createJavadocNode(parseTreeNode, null, -1);
        int childCount = parseTreeNode.getChildCount();
        DetailNode[] children = new JavadocNodeImpl[childCount];
        for (int i = 0; i < childCount; ++i) {
            JavadocNodeImpl child = this.createJavadocNode(parseTreeNode.getChild(i), rootJavadocNode, i);
            children[i] = child;
        }
        rootJavadocNode.setChildren(children);
        return rootJavadocNode;
    }

    private JavadocNodeImpl createJavadocNode(ParseTree parseTree, DetailNode parent, int index) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        node.setText(parseTree.getText());
        node.setColumnNumber(AbstractJavadocCheck.getColumn(parseTree));
        node.setLineNumber(AbstractJavadocCheck.getLine(parseTree) + this.blockCommentAst.getLineNo());
        node.setIndex(index);
        node.setType(AbstractJavadocCheck.getTokenType(parseTree));
        node.setParent(parent);
        node.setChildren(new JavadocNodeImpl[parseTree.getChildCount()]);
        return node;
    }

    private static ParseTree getNextSibling(ParseTree node) {
        ParseTree nextSibling = null;
        if (node.getParent() != null) {
            ParseTree parent = node.getParent();
            int childCount = parent.getChildCount();
            int index = 0;
            while (true) {
                ParseTree currentNode;
                if ((currentNode = parent.getChild(index)).equals(node)) {
                    if (index == childCount - 1) break;
                    nextSibling = parent.getChild(index + 1);
                    break;
                }
                ++index;
            }
        }
        return nextSibling;
    }

    private static int getTokenType(ParseTree node) {
        int tokenType;
        if (node.getChildCount() == 0) {
            tokenType = ((TerminalNode)node).getSymbol().getType();
        } else {
            String className = AbstractJavadocCheck.getNodeClassNameWithoutContext(node);
            String typeName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, className);
            tokenType = JavadocUtils.getTokenId(typeName);
        }
        return tokenType;
    }

    private static String getNodeClassNameWithoutContext(ParseTree node) {
        String className = node.getClass().getSimpleName();
        int contextLength = 7;
        return className.substring(0, className.length() - 7);
    }

    private static int getLine(ParseTree tree) {
        if (tree instanceof TerminalNode) {
            return ((TerminalNode)tree).getSymbol().getLine() - 1;
        }
        ParserRuleContext rule = (ParserRuleContext)tree;
        return rule.start.getLine() - 1;
    }

    private static int getColumn(ParseTree tree) {
        if (tree instanceof TerminalNode) {
            return ((TerminalNode)tree).getSymbol().getCharPositionInLine();
        }
        ParserRuleContext rule = (ParserRuleContext)tree;
        return rule.start.getCharPositionInLine();
    }

    private ParseTree parseJavadocAsParseTree(String blockComment) {
        ANTLRInputStream input = new ANTLRInputStream(blockComment);
        JavadocLexer lexer = new JavadocLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(this.errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavadocParser parser = new JavadocParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(this.errorListener);
        parser.setErrorHandler(new BailErrorStrategy());
        return parser.javadoc();
    }

    private void processTree(DetailNode root) {
        this.beginJavadocTree(root);
        this.walk(root);
        this.finishJavadocTree(root);
    }

    private void walk(DetailNode root) {
        int[] defaultTokenTypes = this.getDefaultJavadocTokens();
        DetailNode curNode = root;
        while (curNode != null) {
            boolean waitsFor = Ints.contains(defaultTokenTypes, curNode.getType());
            if (waitsFor) {
                this.visitJavadocToken(curNode);
            }
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                if (waitsFor) {
                    this.leaveJavadocToken(curNode);
                }
                if ((toVisit = JavadocUtils.getNextSibling(curNode)) != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    private static class ParseErrorMessage {
        private final int lineNumber;
        private final String messageKey;
        private final Object[] messageArguments;

        ParseErrorMessage(int lineNumber, String messageKey, Object ... messageArguments) {
            this.lineNumber = lineNumber;
            this.messageKey = messageKey;
            this.messageArguments = (Object[])messageArguments.clone();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public Object[] getMessageArguments() {
            return (Object[])this.messageArguments.clone();
        }
    }

    private static class ParseStatus {
        private DetailNode tree;
        private ParseErrorMessage parseErrorMessage;

        private ParseStatus() {
        }

        public DetailNode getTree() {
            return this.tree;
        }

        public void setTree(DetailNode tree) {
            this.tree = tree;
        }

        public ParseErrorMessage getParseErrorMessage() {
            return this.parseErrorMessage;
        }

        public void setParseErrorMessage(ParseErrorMessage parseErrorMessage) {
            this.parseErrorMessage = parseErrorMessage;
        }
    }

    private static class DescriptiveErrorListener
    extends BaseErrorListener {
        private static final String JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
        private int offset;
        private ParseErrorMessage errorMessage;

        private DescriptiveErrorListener() {
        }

        private ParseErrorMessage getErrorMessage() {
            return this.errorMessage;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            int lineNumber = this.offset + line;
            Token token = (Token)offendingSymbol;
            if (AbstractJavadocCheck.JAVADOC_MISSED_HTML_CLOSE.equals(msg)) {
                this.errorMessage = new ParseErrorMessage(lineNumber, AbstractJavadocCheck.JAVADOC_MISSED_HTML_CLOSE, charPositionInLine, token.getText());
                throw new ParseCancellationException(msg);
            }
            if (AbstractJavadocCheck.JAVADOC_WRONG_SINGLETON_TAG.equals(msg)) {
                this.errorMessage = new ParseErrorMessage(lineNumber, AbstractJavadocCheck.JAVADOC_WRONG_SINGLETON_TAG, charPositionInLine, token.getText());
                throw new ParseCancellationException(msg);
            }
            int ruleIndex = ex.getCtx().getRuleIndex();
            String ruleName = recognizer.getRuleNames()[ruleIndex];
            String upperCaseRuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ruleName);
            this.errorMessage = new ParseErrorMessage(lineNumber, JAVADOC_PARSE_RULE_ERROR, charPositionInLine, msg, upperCaseRuleName);
        }
    }
}

