/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.checks.regexp.MatchSuppressor;
import com.puppycrawl.tools.checkstyle.checks.regexp.NeverSuppress;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;

final class DetectorOptions {
    private int compileFlags;
    private AbstractViolationReporter reporter;
    private String format;
    private String message = "";
    private int minimum;
    private int maximum;
    private boolean ignoreCase;
    private MatchSuppressor suppressor;
    private Pattern pattern;

    private DetectorOptions() {
    }

    public String getFormat() {
        return this.format;
    }

    public AbstractViolationReporter getReporter() {
        return this.reporter;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public MatchSuppressor getSuppressor() {
        return this.suppressor;
    }

    public Pattern getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        int options = this.compileFlags;
        if (this.ignoreCase) {
            options |= 2;
        }
        this.pattern = Pattern.compile(this.format, options);
        return this.pattern;
    }

    static Builder newBuilder() {
        return new DetectorOptions().new Builder();
    }

    public final class Builder {
        Builder reporter(AbstractViolationReporter val) {
            DetectorOptions.this.reporter = val;
            return this;
        }

        Builder compileFlags(int val) {
            DetectorOptions.this.compileFlags = val;
            return this;
        }

        Builder format(String val) {
            DetectorOptions.this.format = val;
            return this;
        }

        Builder message(String val) {
            DetectorOptions.this.message = val;
            return this;
        }

        Builder minimum(int val) {
            DetectorOptions.this.minimum = val;
            return this;
        }

        Builder maximum(int val) {
            DetectorOptions.this.maximum = val;
            return this;
        }

        Builder ignoreCase(boolean val) {
            DetectorOptions.this.ignoreCase = val;
            return this;
        }

        Builder suppressor(MatchSuppressor val) {
            DetectorOptions.this.suppressor = val;
            return this;
        }

        DetectorOptions build() {
            DetectorOptions.this.message = ObjectUtils.defaultIfNull(DetectorOptions.this.message, "");
            DetectorOptions.this.suppressor = ObjectUtils.defaultIfNull(DetectorOptions.this.suppressor, NeverSuppress.INSTANCE);
            return DetectorOptions.this;
        }
    }
}

