/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AtclauseOrderCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "at.clause.order";
    private static final String COMMA_SEPARATOR = ",";
    private static final String[] DEFAULT_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated"};
    private List<Integer> target = Arrays.asList(14, 15, 154, 9, 8, 10);
    private List<String> tagOrder = Arrays.asList(DEFAULT_ORDER);

    public void setTarget(String target) {
        String[] sTarget;
        ArrayList<Integer> customTarget = new ArrayList<Integer>();
        for (String aSTarget : sTarget = target.split(COMMA_SEPARATOR)) {
            customTarget.add(TokenUtils.getTokenId(aSTarget.trim()));
        }
        this.target = customTarget;
    }

    public void setTagOrder(String order) {
        String[] sOrder;
        ArrayList<String> customOrder = new ArrayList<String>();
        for (String aSOrder : sOrder = order.split(COMMA_SEPARATOR)) {
            customOrder.add(aSOrder.trim());
        }
        this.tagOrder = customOrder;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{145};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        int parentType = AtclauseOrderCheck.getParentType(this.getBlockCommentAst());
        if (this.target.contains(parentType)) {
            this.checkOrderInTagSection(ast);
        }
    }

    private void checkOrderInTagSection(DetailNode javadoc) {
        int maxIndexOfPreviousTag = 0;
        for (DetailNode node : javadoc.getChildren()) {
            String tagText;
            int indexOfCurrentTag;
            if (node.getType() != 10071 || (indexOfCurrentTag = this.tagOrder.indexOf(tagText = JavadocUtils.getFirstChild(node).getText())) == -1) continue;
            if (indexOfCurrentTag < maxIndexOfPreviousTag) {
                this.log(node.getLineNumber(), MSG_KEY, this.tagOrder.toString());
                continue;
            }
            maxIndexOfPreviousTag = indexOfCurrentTag;
        }
    }

    private static int getParentType(DetailAST commentBlock) {
        int type = 0;
        DetailAST parentNode = commentBlock.getParent();
        if (parentNode != null && ((type = parentNode.getType()) == 13 || type == 5)) {
            type = parentNode.getParent().getType();
        }
        return type;
    }
}

