/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;

public final class NestedIfDepthCheck
extends Check {
    public static final String MSG_KEY = "nested.if.depth";
    private int max = 1;
    private int depth;

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{83};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.depth = 0;
    }

    @Override
    public void visitToken(DetailAST literalIf) {
        if (!CheckUtils.isElseIf(literalIf)) {
            if (this.depth > this.max) {
                this.log(literalIf, MSG_KEY, this.depth, this.max);
            }
            ++this.depth;
        }
    }

    @Override
    public void leaveToken(DetailAST literalIf) {
        if (!CheckUtils.isElseIf(literalIf)) {
            --this.depth;
        }
    }
}

