/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util.annotations;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.util.ClassAccessor;
import nl.jqno.equalsverifier.util.annotations.Annotation;
import nl.jqno.equalsverifier.util.annotations.SupportedAnnotations;

public class NonnullAnnotationChecker {
    public static boolean fieldIsNonnull(ClassAccessor<?> classAccessor, Field field) {
        if (classAccessor.fieldHasAnnotation(field, SupportedAnnotations.NONNULL)) {
            return true;
        }
        if (classAccessor.fieldHasAnnotation(field, SupportedAnnotations.NULLABLE)) {
            return false;
        }
        return NonnullAnnotationChecker.annotationIsInScope(classAccessor, SupportedAnnotations.FINDBUGS1X_DEFAULT_ANNOTATION_NONNULL) || NonnullAnnotationChecker.annotationIsInScope(classAccessor, SupportedAnnotations.JSR305_DEFAULT_ANNOTATION_NONNULL) || NonnullAnnotationChecker.annotationIsInScope(classAccessor, SupportedAnnotations.ECLIPSE_DEFAULT_ANNOTATION_NONNULL);
    }

    private static boolean annotationIsInScope(ClassAccessor<?> classAccessor, Annotation annotation) {
        return classAccessor.hasAnnotation(annotation) || classAccessor.outerClassHasAnnotation(annotation) || classAccessor.packageHasAnnotation(annotation);
    }
}

