/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.jqno.equalsverifier.internal.asm.AnnotationVisitor;
import nl.jqno.equalsverifier.internal.asm.ClassReader;
import nl.jqno.equalsverifier.internal.asm.ClassVisitor;
import nl.jqno.equalsverifier.internal.asm.FieldVisitor;
import nl.jqno.equalsverifier.internal.asm.Type;
import nl.jqno.equalsverifier.internal.asm.TypePath;
import nl.jqno.equalsverifier.util.annotations.Annotation;
import nl.jqno.equalsverifier.util.annotations.AnnotationProperties;
import nl.jqno.equalsverifier.util.exceptions.ReflectionException;

public class AnnotationAccessor {
    private final Annotation[] supportedAnnotations;
    private final Class<?> type;
    private final boolean ignoreFailure;
    private final Set<Annotation> classAnnotations = new HashSet<Annotation>();
    private final Map<String, Set<Annotation>> fieldAnnotations = new HashMap<String, Set<Annotation>>();
    private boolean processed = false;
    private boolean shortCircuit = false;

    public AnnotationAccessor(Annotation[] supportedAnnotations, Class<?> type, boolean ignoreFailure) {
        this.supportedAnnotations = supportedAnnotations;
        this.type = type;
        this.ignoreFailure = ignoreFailure;
    }

    public boolean typeHas(Annotation annotation) {
        if (this.shortCircuit) {
            return false;
        }
        this.process();
        return this.classAnnotations.contains(annotation);
    }

    public boolean fieldHas(String fieldName, Annotation annotation) {
        if (this.shortCircuit || fieldName.startsWith("CGLIB$")) {
            return false;
        }
        this.process();
        Set<Annotation> annotations = this.fieldAnnotations.get(fieldName);
        if (annotations == null) {
            throw new ReflectionException("Class " + this.type.getName() + " does not have field " + fieldName);
        }
        return annotations.contains(annotation);
    }

    private void process() {
        if (this.processed) {
            return;
        }
        this.visit();
        this.processed = true;
    }

    private void visit() {
        this.visitType(this.type, false);
        for (Class<?> i = this.type.getSuperclass(); i != null && i != Object.class; i = i.getSuperclass()) {
            this.visitType(i, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitType(Class<?> type, boolean inheriting) {
        block11: {
            ClassLoader classLoader = this.getClassLoaderFor(type);
            Type asmType = Type.getType(type);
            String url = asmType.getInternalName() + ".class";
            InputStream is = null;
            try {
                is = classLoader.getResourceAsStream(url);
                Visitor v = new Visitor(inheriting);
                try {
                    ClassReader cr = new ClassReader(is);
                    cr.accept(v, 0);
                }
                catch (IOException e) {
                    if (this.ignoreFailure) {
                        this.shortCircuit = true;
                        break block11;
                    }
                    throw new ReflectionException("Cannot read class file for " + type.getSimpleName() + ".\nSuppress Warning.ANNOTATION to skip annotation processing phase.");
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private ClassLoader getClassLoaderFor(Class<?> type) {
        ClassLoader result = type.getClassLoader();
        if (result == null) {
            result = ClassLoader.getSystemClassLoader();
        }
        return result;
    }

    private class AnnotationArrayValueVisitor
    extends AnnotationVisitor {
        private final Set<Object> foundAnnotations;

        public AnnotationArrayValueVisitor(Set<Object> foundAnnotations) {
            super(327680);
            this.foundAnnotations = foundAnnotations;
        }

        @Override
        public void visit(String name, Object value) {
            this.foundAnnotations.add(value);
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.foundAnnotations.add(value);
        }
    }

    private class MyAnnotationVisitor
    extends AnnotationVisitor {
        private final String annotationDescriptor;
        private final Set<Annotation> annotations;
        private final boolean inheriting;
        private final AnnotationProperties properties;

        public MyAnnotationVisitor(String annotationDescriptor, Set<Annotation> annotations, boolean inheriting) {
            super(327680);
            this.annotationDescriptor = annotationDescriptor;
            this.annotations = annotations;
            this.inheriting = inheriting;
            this.properties = new AnnotationProperties(annotationDescriptor);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            HashSet<Object> foundAnnotations = new HashSet<Object>();
            this.properties.putArrayValues(name, foundAnnotations);
            return new AnnotationArrayValueVisitor(foundAnnotations);
        }

        @Override
        public void visitEnd() {
            for (Annotation annotation : AnnotationAccessor.this.supportedAnnotations) {
                if (this.inheriting && !annotation.inherits()) continue;
                for (String descriptor : annotation.descriptors()) {
                    String asBytecodeIdentifier = descriptor.replaceAll("\\.", "/") + ";";
                    if (!this.annotationDescriptor.endsWith(asBytecodeIdentifier) || !annotation.validate(this.properties)) continue;
                    this.annotations.add(annotation);
                }
            }
        }
    }

    private class MyFieldVisitor
    extends FieldVisitor {
        private final Set<Annotation> fieldAnnotations;
        private final boolean inheriting;

        public MyFieldVisitor(Set<Annotation> fieldAnnotations, boolean inheriting) {
            super(327680);
            this.fieldAnnotations = fieldAnnotations;
            this.inheriting = inheriting;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            return new MyAnnotationVisitor(descriptor, this.fieldAnnotations, this.inheriting);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return new MyAnnotationVisitor(descriptor, this.fieldAnnotations, this.inheriting);
        }
    }

    private class Visitor
    extends ClassVisitor {
        private final boolean inheriting;

        public Visitor(boolean inheriting) {
            super(327680);
            this.inheriting = inheriting;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return new MyAnnotationVisitor(descriptor, AnnotationAccessor.this.classAnnotations, this.inheriting);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            AnnotationAccessor.this.fieldAnnotations.put(name, annotations);
            return new MyFieldVisitor(annotations, this.inheriting);
        }
    }
}

