/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import nl.jqno.equalsverifier.util.FieldAccessor;
import nl.jqno.equalsverifier.util.FieldIterable;
import nl.jqno.equalsverifier.util.ObjectAccessor;

public class StaticFieldValueStash {
    private final Map<Class<?>, Map<Field, Object>> stash = new HashMap();

    public <T> void backup(Class<T> type) {
        if (this.stash.containsKey(type)) {
            return;
        }
        this.stash.put(type, new HashMap());
        ObjectAccessor<Object> objectAccessor = ObjectAccessor.of(null, type);
        for (Field field : FieldIterable.of(type)) {
            FieldAccessor accessor = objectAccessor.fieldAccessorFor(field);
            if (!accessor.fieldIsStatic()) continue;
            this.stash.get(type).put(field, accessor.get());
        }
    }

    public void restoreAll() {
        for (Class<?> type : this.stash.keySet()) {
            ObjectAccessor<Object> objectAccessor = ObjectAccessor.of(null, type);
            for (Field field : FieldIterable.of(type)) {
                FieldAccessor accessor = objectAccessor.fieldAccessorFor(field);
                if (!accessor.fieldIsStatic()) continue;
                accessor.set(this.stash.get(type).get(field));
            }
        }
    }
}

