/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import nl.jqno.equalsverifier.util.ClassAccessor;
import nl.jqno.equalsverifier.util.FieldIterable;
import nl.jqno.equalsverifier.util.StaticFieldValueStash;
import nl.jqno.equalsverifier.util.exceptions.RecursionException;
import nl.jqno.equalsverifier.util.exceptions.ReflectionException;

public class PrefabValues {
    private final StaticFieldValueStash stash;
    private final Map<Class<?>, Tuple<?>> values = new HashMap();

    public PrefabValues() {
        this(new StaticFieldValueStash());
    }

    public PrefabValues(StaticFieldValueStash stash) {
        this.stash = stash;
    }

    public void backupToStash(Class<?> type) {
        this.stash.backup(type);
    }

    public void restoreFromStash() {
        this.stash.restoreAll();
    }

    public <T> void put(Class<T> type, T red, T black) {
        this.values.put(type, new Tuple(red, black));
    }

    public void putAll(PrefabValues from) {
        this.values.putAll(from.values);
    }

    public boolean contains(Class<?> type) {
        return this.values.containsKey(type);
    }

    public <T> T getRed(Class<T> type) {
        return (T)((Tuple)this.getTuple(type)).red;
    }

    public <T> T getBlack(Class<T> type) {
        return (T)((Tuple)this.getTuple(type)).black;
    }

    private <T> Tuple<T> getTuple(Class<T> type) {
        return this.values.get(type);
    }

    public Object getOther(Class<?> type, Object value) {
        if (type == null) {
            throw new ReflectionException("Type is null.");
        }
        if (value != null && !type.isAssignableFrom(value.getClass()) && !this.wraps(type, value.getClass())) {
            throw new ReflectionException("Type does not match value.");
        }
        Tuple<?> tuple = this.values.get(type);
        if (tuple == null) {
            throw new ReflectionException("No prefab values for " + type + " exist.");
        }
        if (type.isArray() && this.arraysAreDeeplyEqual(((Tuple)tuple).red, value)) {
            return ((Tuple)tuple).black;
        }
        if (!type.isArray() && ((Tuple)tuple).red.equals(value)) {
            return ((Tuple)tuple).black;
        }
        return ((Tuple)tuple).red;
    }

    private boolean wraps(Class<?> expectedClass, Class<?> actualClass) {
        return expectedClass.equals(Boolean.TYPE) && actualClass.equals(Boolean.class) || expectedClass.equals(Byte.TYPE) && actualClass.equals(Byte.class) || expectedClass.equals(Character.TYPE) && actualClass.equals(Character.class) || expectedClass.equals(Double.TYPE) && actualClass.equals(Double.class) || expectedClass.equals(Float.TYPE) && actualClass.equals(Float.class) || expectedClass.equals(Integer.TYPE) && actualClass.equals(Integer.class) || expectedClass.equals(Long.TYPE) && actualClass.equals(Long.class) || expectedClass.equals(Short.TYPE) && actualClass.equals(Short.class);
    }

    private boolean arraysAreDeeplyEqual(Object x, Object y) {
        return Arrays.deepEquals(new Object[]{x}, new Object[]{y});
    }

    public void putFor(Class<?> type) {
        this.putFor(type, new LinkedHashSet());
    }

    private void putFor(Class<?> type, LinkedHashSet<Class<?>> typeStack) {
        if (this.noNeedToCreatePrefabValues(type)) {
            return;
        }
        if (typeStack.contains(type)) {
            throw new RecursionException(typeStack);
        }
        this.stash.backup(type);
        LinkedHashSet clone = (LinkedHashSet)typeStack.clone();
        clone.add(type);
        if (type.isEnum()) {
            this.putEnumInstances(type);
        } else if (type.isArray()) {
            this.putArrayInstances(type, clone);
        } else {
            this.traverseFields(type, clone);
            this.createAndPutInstances(type);
        }
    }

    private boolean noNeedToCreatePrefabValues(Class<?> type) {
        return this.contains(type) || type.isPrimitive();
    }

    private <T> void putEnumInstances(Class<T> type) {
        T[] enumConstants = type.getEnumConstants();
        switch (enumConstants.length) {
            case 0: {
                throw new ReflectionException("Enum " + type.getSimpleName() + " has no elements");
            }
            case 1: {
                this.put(type, enumConstants[0], enumConstants[0]);
                break;
            }
            default: {
                this.put(type, enumConstants[0], enumConstants[1]);
            }
        }
    }

    private <T> void putArrayInstances(Class<T> type, LinkedHashSet<Class<?>> typeStack) {
        Class<?> componentType = type.getComponentType();
        this.putFor(componentType, typeStack);
        Object red = Array.newInstance(componentType, 1);
        Array.set(red, 0, this.getRed(componentType));
        Object black = Array.newInstance(componentType, 1);
        Array.set(black, 0, this.getBlack(componentType));
        this.put(type, red, black);
    }

    private void traverseFields(Class<?> type, LinkedHashSet<Class<?>> typeStack) {
        for (Field field : FieldIterable.of(type)) {
            int modifiers = field.getModifiers();
            boolean isStaticAndFinal = Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
            if (isStaticAndFinal) continue;
            this.putFor(field.getType(), typeStack);
        }
    }

    private <T> void createAndPutInstances(Class<T> type) {
        ClassAccessor<T> accessor = ClassAccessor.of(type, this, false);
        T red = accessor.getRedObject();
        T black = accessor.getBlackObject();
        this.put(type, red, black);
    }

    private static class Tuple<T> {
        private T red;
        private T black;

        private Tuple(T red, T black) {
            this.red = red;
            this.black = black;
        }
    }
}

