/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util;

import java.lang.reflect.Modifier;
import java.util.List;
import nl.jqno.equalsverifier.internal.cglib.proxy.Enhancer;
import nl.jqno.equalsverifier.internal.cglib.proxy.NoOp;
import nl.jqno.equalsverifier.internal.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.objenesis.ObjenesisStd;

public class Instantiator<T> {
    private final Class<T> type;
    private Objenesis objenesis;

    public static <T> Instantiator<T> of(Class<T> type) {
        if (Modifier.isAbstract(type.getModifiers())) {
            return new Instantiator<T>(Instantiator.createDynamicSubclass(type));
        }
        return new Instantiator<T>(type);
    }

    private Instantiator(Class<T> type) {
        this.type = type;
        this.objenesis = new ObjenesisStd();
    }

    public T instantiate() {
        return this.objenesis.newInstance(this.type);
    }

    public T instantiateAnonymousSubclass() {
        Class<T> proxyClass = Instantiator.createDynamicSubclass(this.type);
        return this.objenesis.newInstance(proxyClass);
    }

    private static <S> Class<S> createDynamicSubclass(Class<S> superclass) {
        Enhancer e = new Enhancer(){

            @Override
            protected void filterConstructors(Class sc, List constructors) {
            }
        };
        if (superclass.isInterface()) {
            e.setInterfaces(new Class[]{superclass});
        } else {
            e.setSuperclass(superclass);
        }
        e.setCallbackType(NoOp.class);
        Class proxyClass = e.createClass();
        return proxyClass;
    }
}

