/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FieldIterable
implements Iterable<Field> {
    private final Class<?> type;
    private final boolean includeSuperclasses;

    public static FieldIterable of(Class<?> type) {
        return new FieldIterable(type, true);
    }

    public static FieldIterable ofIgnoringSuper(Class<?> type) {
        return new FieldIterable(type, false);
    }

    private FieldIterable(Class<?> type, boolean includeSuperclasses) {
        this.type = type;
        this.includeSuperclasses = includeSuperclasses;
    }

    @Override
    public Iterator<Field> iterator() {
        return this.createFieldList().iterator();
    }

    private List<Field> createFieldList() {
        ArrayList<Field> result = new ArrayList<Field>();
        result.addAll(this.addFieldsFor(this.type));
        for (Class<?> i = this.type.getSuperclass(); this.includeSuperclasses && i != null && i != Object.class; i = i.getSuperclass()) {
            result.addAll(this.addFieldsFor(i));
        }
        return result;
    }

    private List<Field> addFieldsFor(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : type.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            result.add(field);
        }
        return result;
    }
}

