/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util;

import java.util.ArrayList;
import java.util.List;
import nl.jqno.equalsverifier.util.ConditionalInstantiator;
import nl.jqno.equalsverifier.util.PrefabValues;
import nl.jqno.equalsverifier.util.exceptions.EqualsVerifierBugException;
import nl.jqno.equalsverifier.util.exceptions.ReflectionException;

public class ConditionalPrefabValueBuilder {
    private final Class<?> type;
    private boolean stop = false;
    private ConditionalInstantiator ci;
    private List<Object> instances = new ArrayList<Object>();

    public static ConditionalPrefabValueBuilder of(String fullyQualifiedClassName) {
        return new ConditionalPrefabValueBuilder(fullyQualifiedClassName);
    }

    private ConditionalPrefabValueBuilder(String fullyQualifiedClassName) {
        this.ci = new ConditionalInstantiator(fullyQualifiedClassName);
        this.type = this.ci.resolve();
        if (this.type == null) {
            this.stop = true;
        }
    }

    public ConditionalPrefabValueBuilder withConcreteClass(String fullyQualifiedClassName) {
        if (this.stop) {
            return this;
        }
        this.ci = new ConditionalInstantiator(fullyQualifiedClassName);
        Class<?> concreteType = this.ci.resolve();
        if (concreteType == null) {
            this.stop = true;
            return this;
        }
        if (!this.type.isAssignableFrom(concreteType)) {
            throw new EqualsVerifierBugException("Concrete class " + fullyQualifiedClassName + " is not an " + this.type.getCanonicalName());
        }
        return this;
    }

    public ConditionalPrefabValueBuilder instantiate(final Class<?>[] paramTypes, final Object[] paramValues) {
        this.add(new Supplier(){

            @Override
            public Object get() {
                return ConditionalPrefabValueBuilder.this.ci.instantiate(paramTypes, paramValues);
            }
        });
        return this;
    }

    public ConditionalPrefabValueBuilder instantiate(final Class<?>[] paramTypes, final PrefabValues prefabValues) {
        this.add(new Supplier(){

            @Override
            public Object get() {
                ArrayList objects = new ArrayList();
                for (Class type : paramTypes) {
                    if (!prefabValues.contains(type)) {
                        throw new EqualsVerifierBugException("No prefab values available for type " + type.getCanonicalName());
                    }
                    if (ConditionalPrefabValueBuilder.this.instances.size() == 0) {
                        objects.add(prefabValues.getRed(type));
                        continue;
                    }
                    objects.add(prefabValues.getBlack(type));
                }
                return ConditionalPrefabValueBuilder.this.ci.instantiate(paramTypes, objects.toArray());
            }
        });
        return this;
    }

    public ConditionalPrefabValueBuilder callFactory(final String factoryMethod, final Class<?>[] paramTypes, final Object[] paramValues) {
        this.add(new Supplier(){

            @Override
            public Object get() {
                return ConditionalPrefabValueBuilder.this.ci.callFactory(factoryMethod, paramTypes, paramValues);
            }
        });
        return this;
    }

    public ConditionalPrefabValueBuilder callFactory(final String factoryType, final String factoryMethod, final Class<?>[] paramTypes, final Object[] paramValues) {
        this.add(new Supplier(){

            @Override
            public Object get() {
                return ConditionalPrefabValueBuilder.this.ci.callFactory(factoryType, factoryMethod, paramTypes, paramValues);
            }
        });
        return this;
    }

    public ConditionalPrefabValueBuilder withConstant(final String constantName) {
        this.add(new Supplier(){

            @Override
            public Object get() {
                return ConditionalPrefabValueBuilder.this.ci.returnConstant(constantName);
            }
        });
        return this;
    }

    public void addTo(PrefabValues prefabValues) {
        if (!this.stop) {
            if (this.instances.size() < 2) {
                throw new EqualsVerifierBugException("Not enough instances");
            }
            prefabValues.put(this.type, this.instances.get(0), this.instances.get(1));
        }
    }

    private void add(Supplier obtainer) {
        if (!this.stop) {
            if (this.instances.size() >= 2) {
                throw new EqualsVerifierBugException("Too many instances");
            }
            try {
                this.instances.add(obtainer.get());
            }
            catch (ReflectionException e) {
                this.stop = true;
            }
        }
    }

    private static interface Supplier {
        public Object get();
    }
}

