/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import nl.jqno.equalsverifier.util.exceptions.ReflectionException;

public class ConditionalInstantiator {
    private final String fullyQualifiedClassName;

    public ConditionalInstantiator(String fullyQualifiedClassName) {
        this.fullyQualifiedClassName = fullyQualifiedClassName;
    }

    public Class<?> resolve() {
        return ConditionalInstantiator.forName(this.fullyQualifiedClassName);
    }

    public Object instantiate(Class<?>[] paramTypes, Object[] paramValues) {
        try {
            Class<?> type = this.resolve();
            if (type == null) {
                return null;
            }
            Constructor<?> c = type.getConstructor(paramTypes);
            return c.newInstance(paramValues);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public Object callFactory(String factoryMethod, Class<?>[] paramTypes, Object[] paramValues) {
        return this.callFactory(this.fullyQualifiedClassName, factoryMethod, paramTypes, paramValues);
    }

    public Object callFactory(String factoryTypeName, String factoryMethod, Class<?>[] paramTypes, Object[] paramValues) {
        try {
            Class<?> type = this.resolve();
            if (type == null) {
                return null;
            }
            Class<?> factoryType = Class.forName(factoryTypeName);
            Method factory = factoryType.getMethod(factoryMethod, paramTypes);
            return factory.invoke(null, paramValues);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public Object returnConstant(String constantName) {
        try {
            Class<?> type = this.resolve();
            if (type == null) {
                return null;
            }
            Field field = type.getField(constantName);
            return field.get(null);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public static Class<?>[] classes(Class<?> ... classes) {
        return classes;
    }

    public static Object[] objects(Object ... objects) {
        return objects;
    }

    public static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

