/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.util.FieldAccessor;
import nl.jqno.equalsverifier.util.FieldIterable;
import nl.jqno.equalsverifier.util.Instantiator;
import nl.jqno.equalsverifier.util.ObjectAccessor;
import nl.jqno.equalsverifier.util.PrefabValues;
import nl.jqno.equalsverifier.util.annotations.Annotation;
import nl.jqno.equalsverifier.util.annotations.AnnotationAccessor;
import nl.jqno.equalsverifier.util.annotations.NonnullAnnotationChecker;
import nl.jqno.equalsverifier.util.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.util.exceptions.ReflectionException;

public class ClassAccessor<T> {
    private final Class<T> type;
    private final PrefabValues prefabValues;
    private final Annotation[] supportedAnnotations;
    private final boolean ignoreAnnotationFailure;
    private final AnnotationAccessor annotationAccessor;

    public static <T> ClassAccessor<T> of(Class<T> type, PrefabValues prefabValues, boolean ignoreAnnotationFailure) {
        return new ClassAccessor<T>(type, prefabValues, SupportedAnnotations.values(), ignoreAnnotationFailure);
    }

    ClassAccessor(Class<T> type, PrefabValues prefabValues, Annotation[] supportedAnnotations, boolean ignoreAnnotationFailure) {
        this.type = type;
        this.prefabValues = prefabValues;
        this.supportedAnnotations = supportedAnnotations;
        this.ignoreAnnotationFailure = ignoreAnnotationFailure;
        this.annotationAccessor = new AnnotationAccessor(supportedAnnotations, type, ignoreAnnotationFailure);
    }

    public Class<T> getType() {
        return this.type;
    }

    public PrefabValues getPrefabValues() {
        return this.prefabValues;
    }

    public boolean hasAnnotation(Annotation annotation) {
        return this.annotationAccessor.typeHas(annotation);
    }

    public boolean outerClassHasAnnotation(Annotation annotation) {
        for (Class<?> outer = this.type.getDeclaringClass(); outer != null; outer = outer.getDeclaringClass()) {
            AnnotationAccessor accessor = new AnnotationAccessor(this.supportedAnnotations, outer, this.ignoreAnnotationFailure);
            if (!accessor.typeHas(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean packageHasAnnotation(Annotation annotation) {
        try {
            Package pkg = this.type.getPackage();
            if (pkg == null) {
                return false;
            }
            String className = pkg.getName() + ".package-info";
            Class<?> packageType = Class.forName(className);
            AnnotationAccessor accessor = new AnnotationAccessor(this.supportedAnnotations, packageType, this.ignoreAnnotationFailure);
            return accessor.typeHas(annotation);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean fieldHasAnnotation(Field field, Annotation annotation) {
        return this.annotationAccessor.fieldHas(field.getName(), annotation);
    }

    public boolean declaresField(Field field) {
        try {
            this.type.getDeclaredField(field.getName());
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public boolean declaresEquals() {
        return this.declaresMethod("equals", Object.class);
    }

    public boolean declaresHashCode() {
        return this.declaresMethod("hashCode", new Class[0]);
    }

    private boolean declaresMethod(String name, Class<?> ... parameterTypes) {
        try {
            this.type.getDeclaredMethod(name, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isEqualsAbstract() {
        return this.isMethodAbstract("equals", Object.class);
    }

    public boolean isHashCodeAbstract() {
        return this.isMethodAbstract("hashCode", new Class[0]);
    }

    private boolean isMethodAbstract(String name, Class<?> ... parameterTypes) {
        try {
            return Modifier.isAbstract(this.type.getMethod(name, parameterTypes).getModifiers());
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Should never occur (famous last words)");
        }
    }

    public boolean isEqualsInheritedFromObject() {
        ClassAccessor<T> i = this;
        while (i.getType() != Object.class) {
            if (i.declaresEquals() && !i.isEqualsAbstract()) {
                return false;
            }
            i = i.getSuperAccessor();
        }
        return true;
    }

    public ClassAccessor<? super T> getSuperAccessor() {
        return ClassAccessor.of(this.type.getSuperclass(), this.prefabValues, this.ignoreAnnotationFailure);
    }

    public T getRedObject() {
        return this.getRedAccessor().get();
    }

    public ObjectAccessor<T> getRedAccessor() {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        result.scramble(this.prefabValues);
        return result;
    }

    public T getBlackObject() {
        return this.getBlackAccessor().get();
    }

    public ObjectAccessor<T> getBlackAccessor() {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        result.scramble(this.prefabValues);
        result.scramble(this.prefabValues);
        return result;
    }

    public T getDefaultValuesObject() {
        return this.getDefaultValuesAccessor().get();
    }

    public ObjectAccessor<T> getDefaultValuesAccessor() {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        for (Field field : FieldIterable.of(this.type)) {
            if (!NonnullAnnotationChecker.fieldIsNonnull(this, field)) continue;
            FieldAccessor accessor = result.fieldAccessorFor(field);
            accessor.changeField(this.prefabValues);
        }
        return result;
    }

    private ObjectAccessor<T> buildObjectAccessor() {
        T object = Instantiator.of(this.type).instantiate();
        return ObjectAccessor.of(object);
    }
}

