/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.objenesis.strategy;

import java.io.NotSerializableException;
import java.io.Serializable;
import nl.jqno.equalsverifier.internal.objenesis.ObjenesisException;
import nl.jqno.equalsverifier.internal.objenesis.instantiator.ObjectInstantiator;
import nl.jqno.equalsverifier.internal.objenesis.instantiator.android.AndroidSerializationInstantiator;
import nl.jqno.equalsverifier.internal.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import nl.jqno.equalsverifier.internal.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import nl.jqno.equalsverifier.internal.objenesis.instantiator.perc.PercSerializationInstantiator;
import nl.jqno.equalsverifier.internal.objenesis.strategy.BaseInstantiatorStrategy;
import nl.jqno.equalsverifier.internal.objenesis.strategy.PlatformDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            return new ObjectStreamClassInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            return new AndroidSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type);
        }
        return new ObjectStreamClassInstantiator<T>(type);
    }
}

