/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.cglib.transform.impl;

import java.lang.reflect.Method;
import nl.jqno.equalsverifier.internal.asm.Type;
import nl.jqno.equalsverifier.internal.cglib.core.CodeEmitter;
import nl.jqno.equalsverifier.internal.cglib.core.Constants;
import nl.jqno.equalsverifier.internal.cglib.core.EmitUtils;
import nl.jqno.equalsverifier.internal.cglib.core.MethodInfo;
import nl.jqno.equalsverifier.internal.cglib.core.ReflectUtils;
import nl.jqno.equalsverifier.internal.cglib.core.TypeUtils;
import nl.jqno.equalsverifier.internal.cglib.transform.ClassEmitterTransformer;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddStaticInitTransformer(Method classInit) {
        this.info = ReflectUtils.getMethodInfo(classInit);
        if (!TypeUtils.isStatic(this.info.getModifiers())) {
            throw new IllegalArgumentException(classInit + " is not static");
        }
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constants.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(classInit + " illegal signature");
        }
    }

    protected void init() {
        if (!TypeUtils.isInterface(this.getAccess())) {
            CodeEmitter e = this.getStaticHook();
            EmitUtils.load_class_this(e);
            e.invoke(this.info);
        }
    }
}

