/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import nl.jqno.equalsverifier.Checker;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.util.Assert;
import nl.jqno.equalsverifier.util.Formatter;

class SignatureChecker<T>
implements Checker {
    private final Class<T> type;

    public SignatureChecker(Configuration<T> config) {
        this.type = config.getType();
    }

    @Override
    public void check() {
        List<Method> equalsMethods = this.getEqualsMethods();
        if (equalsMethods.size() > 1) {
            this.fail("More than one equals method found");
        }
        if (equalsMethods.size() == 0) {
            return;
        }
        this.checkEquals(equalsMethods.get(0));
    }

    private List<Method> getEqualsMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.type.getDeclaredMethods()) {
            if (!method.getName().equals("equals")) continue;
            result.add(method);
        }
        return result;
    }

    private void checkEquals(Method equals) {
        Class<?> parameterType;
        Class<?>[] parameterTypes = equals.getParameterTypes();
        if (parameterTypes.length > 1) {
            this.fail("Too many parameters");
        }
        if (parameterTypes.length == 0) {
            this.fail("No parameter");
        }
        if ((parameterType = parameterTypes[0]) == this.type) {
            this.fail("Parameter should be an Object, not " + this.type.getSimpleName());
        }
        if (parameterType != Object.class) {
            this.fail("Parameter should be an Object");
        }
    }

    private void fail(String message) {
        Assert.fail(Formatter.of("Overloaded: %%.\nSignature should be: public boolean equals(Object obj)", message));
    }
}

