/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.List;
import nl.jqno.equalsverifier.Checker;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.util.Assert;
import nl.jqno.equalsverifier.util.Formatter;

class PreconditionChecker<T>
implements Checker {
    private final Class<T> type;
    private final List<T> equalExamples;
    private final List<T> unequalExamples;

    public PreconditionChecker(Configuration<T> config, List<T> equalExamples, List<T> unequalExamples) {
        this.type = config.getType();
        this.equalExamples = equalExamples;
        this.unequalExamples = unequalExamples;
    }

    @Override
    public void check() {
        Assert.assertTrue(Formatter.of("Precondition: no examples.", new Object[0]), this.unequalExamples.size() > 0);
        for (T example : this.equalExamples) {
            Assert.assertTrue(Formatter.of("Precondition:\n  %%\nand\n  %%\nare of different classes", this.equalExamples.get(0), example), this.type.isAssignableFrom(example.getClass()));
        }
        for (T example : this.unequalExamples) {
            Assert.assertTrue(Formatter.of("Precondition:\n  %%\nand\n  %%\nare of different classes", this.unequalExamples.get(0), example), this.type.isAssignableFrom(example.getClass()));
        }
    }
}

