/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Queue;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.regex.Pattern;
import javax.naming.Reference;
import nl.jqno.equalsverifier.internal.cglib.proxy.NoOp;
import nl.jqno.equalsverifier.util.ConditionalInstantiator;
import nl.jqno.equalsverifier.util.ConditionalPrefabValueBuilder;
import nl.jqno.equalsverifier.util.PrefabValues;

public class JavaApiPrefabValues {
    private PrefabValues prefabValues;

    public static void addTo(PrefabValues prefabValues) {
        new JavaApiPrefabValues(prefabValues).addJavaClasses();
    }

    private JavaApiPrefabValues(PrefabValues prefabValues) {
        this.prefabValues = prefabValues;
    }

    private void addJavaClasses() {
        this.addPrimitiveClasses();
        this.addClasses();
        this.addCollection();
        this.addLists();
        this.addMaps();
        this.addSets();
        this.addQueues();
        this.addJava8ApiClasses();
        this.addJavaFXClasses();
        this.addGoogleGuavaClasses();
        this.addJodaTimeClasses();
        this.addClassesNecessaryForCgLib();
    }

    private void addPrimitiveClasses() {
        this.prefabValues.put(Boolean.TYPE, true, false);
        this.prefabValues.put(Byte.TYPE, (byte)1, (byte)2);
        this.prefabValues.put(Character.TYPE, Character.valueOf('a'), Character.valueOf('b'));
        this.prefabValues.put(Double.TYPE, 0.5, 1.0);
        this.prefabValues.put(Float.TYPE, Float.valueOf(0.5f), Float.valueOf(1.0f));
        this.prefabValues.put(Integer.TYPE, 1, 2);
        this.prefabValues.put(Long.TYPE, 1L, 2L);
        this.prefabValues.put(Short.TYPE, (short)1, (short)2);
        this.prefabValues.put(Boolean.class, true, false);
        this.prefabValues.put(Byte.class, (byte)1, (byte)2);
        this.prefabValues.put(Character.class, Character.valueOf('a'), Character.valueOf('b'));
        this.prefabValues.put(Double.class, 0.5, 1.0);
        this.prefabValues.put(Float.class, Float.valueOf(0.5f), Float.valueOf(1.0f));
        this.prefabValues.put(Integer.class, 1, 2);
        this.prefabValues.put(Long.class, 1L, 2L);
        this.prefabValues.put(Short.class, (short)1, (short)2);
        this.prefabValues.put(Object.class, new Object(), new Object());
        this.prefabValues.put(Class.class, Class.class, Object.class);
        this.prefabValues.put(String.class, "one", "two");
    }

    private void addClasses() {
        this.prefabValues.put(BigDecimal.class, BigDecimal.ZERO, BigDecimal.ONE);
        this.prefabValues.put(BigInteger.class, BigInteger.ZERO, BigInteger.ONE);
        this.prefabValues.put(Calendar.class, new GregorianCalendar(2010, 7, 4), new GregorianCalendar(2010, 7, 5));
        this.prefabValues.put(Date.class, new Date(0L), new Date(1L));
        this.prefabValues.put(DateFormat.class, DateFormat.getTimeInstance(), DateFormat.getDateInstance());
        this.prefabValues.put(File.class, new File(""), new File("/"));
        this.prefabValues.put(Formatter.class, new Formatter(), new Formatter());
        this.prefabValues.put(GregorianCalendar.class, new GregorianCalendar(2010, 7, 4), new GregorianCalendar(2010, 7, 5));
        this.prefabValues.put(Locale.class, new Locale("nl"), new Locale("hu"));
        this.prefabValues.put(Pattern.class, Pattern.compile("one"), Pattern.compile("two"));
        this.prefabValues.put(Reference.class, new Reference("one"), new Reference("two"));
        this.prefabValues.put(SimpleDateFormat.class, new SimpleDateFormat("yMd"), new SimpleDateFormat("dMy"));
        this.prefabValues.put(Scanner.class, new Scanner("one"), new Scanner("two"));
        this.prefabValues.put(TimeZone.class, TimeZone.getTimeZone("GMT+1"), TimeZone.getTimeZone("GMT+2"));
        this.prefabValues.put(Throwable.class, new Throwable(), new Throwable());
        this.prefabValues.put(UUID.class, new UUID(0L, -1L), new UUID(1L, 0L));
    }

    private void addCollection() {
        this.addCollection(Collection.class, new ArrayList(), new ArrayList());
    }

    private void addLists() {
        this.addCollection(List.class, new ArrayList(), new ArrayList());
        this.addCollection(CopyOnWriteArrayList.class, new CopyOnWriteArrayList(), new CopyOnWriteArrayList());
        this.addCollection(LinkedList.class, new LinkedList(), new LinkedList());
        this.addCollection(ArrayList.class, new ArrayList(), new ArrayList());
    }

    private void addMaps() {
        this.addMap(Map.class, new HashMap(), new HashMap());
        this.addMap(SortedMap.class, new TreeMap(), new TreeMap());
        this.addMap(NavigableMap.class, new TreeMap(), new TreeMap());
        this.addMap(ConcurrentNavigableMap.class, new ConcurrentSkipListMap(), new ConcurrentSkipListMap());
        this.prefabValues.put(EnumMap.class, Dummy.RED.map(), Dummy.BLACK.map());
        this.addMap(ConcurrentHashMap.class, new ConcurrentHashMap(), new ConcurrentHashMap());
        this.addMap(HashMap.class, new HashMap(), new HashMap());
        this.addMap(Hashtable.class, new Hashtable(), new Hashtable());
        this.addMap(LinkedHashMap.class, new LinkedHashMap(), new LinkedHashMap());
        this.addMap(Properties.class, new Properties(), new Properties());
        this.addMap(TreeMap.class, new TreeMap(), new TreeMap());
        this.addMap(WeakHashMap.class, new WeakHashMap(), new WeakHashMap());
    }

    private void addSets() {
        this.addCollection(Set.class, new HashSet(), new HashSet());
        this.addCollection(SortedSet.class, new TreeSet(), new TreeSet());
        this.addCollection(NavigableSet.class, new TreeSet(), new TreeSet());
        this.addCollection(CopyOnWriteArraySet.class, new CopyOnWriteArraySet(), new CopyOnWriteArraySet());
        this.addCollection(TreeSet.class, new TreeSet(), new TreeSet());
        this.prefabValues.put(EnumSet.class, EnumSet.of(Dummy.RED), EnumSet.of(Dummy.BLACK));
        BitSet redBitSet = new BitSet();
        BitSet blackBitSet = new BitSet();
        blackBitSet.set(0);
        this.prefabValues.put(BitSet.class, redBitSet, blackBitSet);
    }

    private void addQueues() {
        this.prefabValues.put(Queue.class, new ArrayBlockingQueue(1), new ArrayBlockingQueue(1));
        this.prefabValues.put(BlockingQueue.class, new ArrayBlockingQueue(1), new ArrayBlockingQueue(1));
        this.prefabValues.put(Deque.class, new ArrayDeque(1), new ArrayDeque(1));
        this.prefabValues.put(BlockingDeque.class, new LinkedBlockingDeque(1), new LinkedBlockingDeque(1));
        this.prefabValues.put(ArrayBlockingQueue.class, new ArrayBlockingQueue(1), new ArrayBlockingQueue(1));
        this.prefabValues.put(ConcurrentLinkedQueue.class, new ConcurrentLinkedQueue(), new ConcurrentLinkedQueue());
        this.prefabValues.put(DelayQueue.class, new DelayQueue(), new DelayQueue());
        this.prefabValues.put(LinkedBlockingQueue.class, new LinkedBlockingQueue(), new LinkedBlockingQueue());
        this.prefabValues.put(PriorityBlockingQueue.class, new PriorityBlockingQueue(), new PriorityBlockingQueue());
        this.prefabValues.put(SynchronousQueue.class, new SynchronousQueue(), new SynchronousQueue());
    }

    private void addJava8ApiClasses() {
        ConditionalPrefabValueBuilder.of("java.time.ZoneId").callFactory("of", ConditionalInstantiator.classes(String.class), ConditionalInstantiator.objects("+1")).callFactory("of", ConditionalInstantiator.classes(String.class), ConditionalInstantiator.objects("-10")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("java.time.format.DateTimeFormatter").withConstant("ISO_TIME").withConstant("ISO_DATE").addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("java.util.concurrent.CompletableFuture").instantiate(ConditionalInstantiator.classes(new Class[0]), ConditionalInstantiator.objects(new Object[0])).instantiate(ConditionalInstantiator.classes(new Class[0]), ConditionalInstantiator.objects(new Object[0])).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("java.util.concurrent.locks.StampedLock").instantiate(ConditionalInstantiator.classes(new Class[0]), ConditionalInstantiator.objects(new Object[0])).instantiate(ConditionalInstantiator.classes(new Class[0]), ConditionalInstantiator.objects(new Object[0])).addTo(this.prefabValues);
    }

    private void addJavaFXClasses() {
        ConditionalPrefabValueBuilder.of("javafx.collections.ObservableList").callFactory("javafx.collections.FXCollections", "observableList", ConditionalInstantiator.classes(List.class), ConditionalInstantiator.objects(this.prefabValues.getRed(List.class))).callFactory("javafx.collections.FXCollections", "observableList", ConditionalInstantiator.classes(List.class), ConditionalInstantiator.objects(this.prefabValues.getBlack(List.class))).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.collections.ObservableMap").callFactory("javafx.collections.FXCollections", "observableMap", ConditionalInstantiator.classes(Map.class), ConditionalInstantiator.objects(this.prefabValues.getRed(Map.class))).callFactory("javafx.collections.FXCollections", "observableMap", ConditionalInstantiator.classes(Map.class), ConditionalInstantiator.objects(this.prefabValues.getBlack(Map.class))).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.collections.ObservableSet").callFactory("javafx.collections.FXCollections", "observableSet", ConditionalInstantiator.classes(Set.class), ConditionalInstantiator.objects(this.prefabValues.getRed(Set.class))).callFactory("javafx.collections.FXCollections", "observableSet", ConditionalInstantiator.classes(Set.class), ConditionalInstantiator.objects(this.prefabValues.getBlack(Set.class))).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.beans.property.BooleanProperty").withConcreteClass("javafx.beans.property.SimpleBooleanProperty").instantiate(ConditionalInstantiator.classes(Boolean.TYPE), ConditionalInstantiator.objects(true)).withConcreteClass("javafx.beans.property.SimpleBooleanProperty").instantiate(ConditionalInstantiator.classes(Boolean.TYPE), ConditionalInstantiator.objects(false)).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.beans.property.DoubleProperty").withConcreteClass("javafx.beans.property.SimpleDoubleProperty").instantiate(ConditionalInstantiator.classes(Double.TYPE), ConditionalInstantiator.objects(1.0)).withConcreteClass("javafx.beans.property.SimpleDoubleProperty").instantiate(ConditionalInstantiator.classes(Double.TYPE), ConditionalInstantiator.objects(2.0)).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.beans.property.FloatProperty").withConcreteClass("javafx.beans.property.SimpleFloatProperty").instantiate(ConditionalInstantiator.classes(Float.TYPE), ConditionalInstantiator.objects(Float.valueOf(1.0f))).withConcreteClass("javafx.beans.property.SimpleFloatProperty").instantiate(ConditionalInstantiator.classes(Float.TYPE), ConditionalInstantiator.objects(Float.valueOf(2.0f))).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.beans.property.IntegerProperty").withConcreteClass("javafx.beans.property.SimpleIntegerProperty").instantiate(ConditionalInstantiator.classes(Integer.TYPE), ConditionalInstantiator.objects(1)).withConcreteClass("javafx.beans.property.SimpleIntegerProperty").instantiate(ConditionalInstantiator.classes(Integer.TYPE), ConditionalInstantiator.objects(2)).addTo(this.prefabValues);
        Class<?> observableList = ConditionalInstantiator.forName("javafx.collections.ObservableList");
        ConditionalPrefabValueBuilder.of("javafx.beans.property.ListProperty").withConcreteClass("javafx.beans.property.SimpleListProperty").instantiate(ConditionalInstantiator.classes(observableList), this.prefabValues).withConcreteClass("javafx.beans.property.SimpleListProperty").instantiate(ConditionalInstantiator.classes(observableList), this.prefabValues).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.beans.property.LongProperty").withConcreteClass("javafx.beans.property.SimpleLongProperty").instantiate(ConditionalInstantiator.classes(Long.TYPE), ConditionalInstantiator.objects(1L)).withConcreteClass("javafx.beans.property.SimpleLongProperty").instantiate(ConditionalInstantiator.classes(Long.TYPE), ConditionalInstantiator.objects(2L)).addTo(this.prefabValues);
        Class<?> observableMap = ConditionalInstantiator.forName("javafx.collections.ObservableMap");
        ConditionalPrefabValueBuilder.of("javafx.beans.property.MapProperty").withConcreteClass("javafx.beans.property.SimpleMapProperty").instantiate(ConditionalInstantiator.classes(observableMap), this.prefabValues).withConcreteClass("javafx.beans.property.SimpleMapProperty").instantiate(ConditionalInstantiator.classes(observableMap), this.prefabValues).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.beans.property.ObjectProperty").withConcreteClass("javafx.beans.property.SimpleObjectProperty").instantiate(ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects(new Object())).withConcreteClass("javafx.beans.property.SimpleObjectProperty").instantiate(ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects(new Object())).addTo(this.prefabValues);
        Class<?> observableSet = ConditionalInstantiator.forName("javafx.collections.ObservableSet");
        ConditionalPrefabValueBuilder.of("javafx.beans.property.SetProperty").withConcreteClass("javafx.beans.property.SimpleSetProperty").instantiate(ConditionalInstantiator.classes(observableSet), this.prefabValues).withConcreteClass("javafx.beans.property.SimpleSetProperty").instantiate(ConditionalInstantiator.classes(observableSet), this.prefabValues).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("javafx.beans.property.StringProperty").withConcreteClass("javafx.beans.property.SimpleStringProperty").instantiate(ConditionalInstantiator.classes(String.class), ConditionalInstantiator.objects("one")).withConcreteClass("javafx.beans.property.SimpleStringProperty").instantiate(ConditionalInstantiator.classes(String.class), ConditionalInstantiator.objects("two")).addTo(this.prefabValues);
    }

    private void addGoogleGuavaClasses() {
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableList").callFactory("of", ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects("red")).callFactory("of", ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects("black")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableMap").callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class), ConditionalInstantiator.objects("red", "value")).callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class), ConditionalInstantiator.objects("black", "value")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableSet").callFactory("of", ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects("red")).callFactory("of", ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects("black")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableSortedMap").callFactory("of", ConditionalInstantiator.classes(Comparable.class, Object.class), ConditionalInstantiator.objects("red", "value")).callFactory("of", ConditionalInstantiator.classes(Comparable.class, Object.class), ConditionalInstantiator.objects("black", "value")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableSortedSet").callFactory("of", ConditionalInstantiator.classes(Comparable.class), ConditionalInstantiator.objects("red")).callFactory("of", ConditionalInstantiator.classes(Comparable.class), ConditionalInstantiator.objects("black")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableMultiset").callFactory("of", ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects("red")).callFactory("of", ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects("black")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableSortedMultiset").callFactory("of", ConditionalInstantiator.classes(Comparable.class), ConditionalInstantiator.objects("red")).callFactory("of", ConditionalInstantiator.classes(Comparable.class), ConditionalInstantiator.objects("black")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableListMultimap").callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class), ConditionalInstantiator.objects("red", "value")).callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class), ConditionalInstantiator.objects("black", "value")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableSetMultimap").callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class), ConditionalInstantiator.objects("red", "value")).callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class), ConditionalInstantiator.objects("black", "value")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableBiMap").callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class), ConditionalInstantiator.objects("red", "value")).callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class), ConditionalInstantiator.objects("black", "value")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.ImmutableTable").callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class, Object.class), ConditionalInstantiator.objects("red", "X", "value")).callFactory("of", ConditionalInstantiator.classes(Object.class, Object.class, Object.class), ConditionalInstantiator.objects("black", "X", "value")).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.collect.Range").callFactory("open", ConditionalInstantiator.classes(Comparable.class, Comparable.class), ConditionalInstantiator.objects(1, 2)).callFactory("open", ConditionalInstantiator.classes(Comparable.class, Comparable.class), ConditionalInstantiator.objects(3, 4)).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("com.google.common.base.Optional").callFactory("of", ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects("red")).callFactory("of", ConditionalInstantiator.classes(Object.class), ConditionalInstantiator.objects("black")).addTo(this.prefabValues);
    }

    private void addJodaTimeClasses() {
        ConditionalPrefabValueBuilder.of("org.joda.time.Chronology").withConcreteClass("org.joda.time.chrono.GregorianChronology").callFactory("getInstanceUTC", ConditionalInstantiator.classes(new Class[0]), ConditionalInstantiator.objects(new Object[0])).withConcreteClass("org.joda.time.chrono.ISOChronology").callFactory("getInstanceUTC", ConditionalInstantiator.classes(new Class[0]), ConditionalInstantiator.objects(new Object[0])).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("org.joda.time.DateTimeZone").callFactory("forOffsetHours", ConditionalInstantiator.classes(Integer.TYPE), ConditionalInstantiator.objects(1)).callFactory("forOffsetHours", ConditionalInstantiator.classes(Integer.TYPE), ConditionalInstantiator.objects(-10)).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("org.joda.time.PeriodType").callFactory("days", ConditionalInstantiator.classes(new Class[0]), ConditionalInstantiator.objects(new Object[0])).callFactory("hours", ConditionalInstantiator.classes(new Class[0]), ConditionalInstantiator.objects(new Object[0])).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("org.joda.time.YearMonth").instantiate(ConditionalInstantiator.classes(Integer.TYPE, Integer.TYPE), ConditionalInstantiator.objects(2009, 6)).instantiate(ConditionalInstantiator.classes(Integer.TYPE, Integer.TYPE), ConditionalInstantiator.objects(2014, 7)).addTo(this.prefabValues);
        ConditionalPrefabValueBuilder.of("org.joda.time.MonthDay").instantiate(ConditionalInstantiator.classes(Integer.TYPE, Integer.TYPE), ConditionalInstantiator.objects(6, 1)).instantiate(ConditionalInstantiator.classes(Integer.TYPE, Integer.TYPE), ConditionalInstantiator.objects(7, 26)).addTo(this.prefabValues);
    }

    private void addClassesNecessaryForCgLib() {
        this.prefabValues.put(NoOp.class, new NoOp(){}, new NoOp(){});
    }

    private <T extends Collection<Object>> void addCollection(Class<T> type, T red, T black) {
        red.add((String)"red");
        black.add((String)"black");
        this.prefabValues.put(type, red, black);
    }

    private <T extends Map<Object, Object>> void addMap(Class<T> type, T red, T black) {
        red.put((String)"red_key", (String)"red_value");
        black.put((String)"black_key", (String)"black_value");
        this.prefabValues.put(type, red, black);
    }

    private static enum Dummy {
        RED,
        BLACK;


        public EnumMap<Dummy, String> map() {
            EnumMap<Dummy, String> result = new EnumMap<Dummy, String>(Dummy.class);
            result.put(this, this.toString());
            return result;
        }
    }
}

