/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.Checker;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.util.Assert;
import nl.jqno.equalsverifier.util.ClassAccessor;
import nl.jqno.equalsverifier.util.Formatter;
import nl.jqno.equalsverifier.util.ObjectAccessor;

class HierarchyChecker<T>
implements Checker {
    private final Configuration<T> config;
    private final Class<T> type;
    private final ClassAccessor<T> classAccessor;
    private final Class<? extends T> redefinedSubclass;
    private final boolean typeIsFinal;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public HierarchyChecker(Configuration<T> config) {
        this.config = config;
        if (config.getWarningsToSuppress().contains((Object)Warning.STRICT_INHERITANCE) && config.getRedefinedSubclass() != null) {
            Assert.fail(Formatter.of("withRedefinedSubclass and weakInheritanceCheck are mutually exclusive.", new Object[0]));
        }
        this.type = config.getType();
        this.classAccessor = config.createClassAccessor();
        this.redefinedSubclass = config.getRedefinedSubclass();
        this.typeIsFinal = Modifier.isFinal(this.type.getModifiers());
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkSuperclass();
        this.checkSubclass();
        this.checkRedefinedSubclass();
        if (!this.config.getWarningsToSuppress().contains((Object)Warning.STRICT_INHERITANCE)) {
            this.checkFinalEqualsMethod();
        }
    }

    private void checkSuperclass() {
        ClassAccessor<T> superAccessor = this.classAccessor.getSuperAccessor();
        if (superAccessor.isEqualsInheritedFromObject()) {
            return;
        }
        if (this.config.hasRedefinedSuperclass() || this.config.isUsingGetClass()) {
            T reference = this.classAccessor.getRedAccessor().get();
            Object equalSuper = this.getEqualSuper(reference);
            Assert.assertFalse(Formatter.of("Redefined superclass:\n  %%\nshould not equal superclass instance\n  %%\nbut it does.", reference, equalSuper), reference.equals(equalSuper) || equalSuper.equals(reference));
        } else {
            this.checkSuperProperties(this.classAccessor.getRedAccessor());
            this.checkSuperProperties(this.classAccessor.getDefaultValuesAccessor());
        }
    }

    private void checkSuperProperties(ObjectAccessor<T> referenceAccessor) {
        T reference = referenceAccessor.get();
        Object equalSuper = this.getEqualSuper(reference);
        T shallow = referenceAccessor.copy();
        ObjectAccessor.of(shallow).shallowScramble(this.classAccessor.getPrefabValues());
        Assert.assertTrue(Formatter.of("Symmetry:\n  %%\ndoes not equal superclass instance\n  %%", reference, equalSuper), reference.equals(equalSuper) && equalSuper.equals(reference));
        Assert.assertTrue(Formatter.of("Transitivity:\n  %%\nand\n  %%\nboth equal superclass instance\n  %%\nwhich implies they equal each other.", reference, shallow, equalSuper), reference.equals(shallow) || reference.equals(equalSuper) != equalSuper.equals(shallow));
        int referenceHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(reference);
        int equalSuperHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(equalSuper);
        Assert.assertTrue(Formatter.of("Superclass: hashCode for\n  %% (%%)\nshould be equal to hashCode for superclass instance\n  %% (%%)", reference, referenceHashCode, equalSuper, equalSuperHashCode), referenceHashCode == equalSuperHashCode);
    }

    private Object getEqualSuper(T reference) {
        return ObjectAccessor.of(reference, this.type.getSuperclass()).copy();
    }

    private void checkSubclass() {
        if (this.typeIsFinal) {
            return;
        }
        ObjectAccessor<T> referenceAccessor = this.classAccessor.getRedAccessor();
        T reference = referenceAccessor.get();
        T equalSub = referenceAccessor.copyIntoAnonymousSubclass();
        if (this.config.isUsingGetClass()) {
            Assert.assertFalse(Formatter.of("Subclass: object is equal to an instance of a trivial subclass with equal fields:\n  %%\nThis should not happen when using getClass().", reference), reference.equals(equalSub));
        } else {
            Assert.assertTrue(Formatter.of("Subclass: object is not equal to an instance of a trivial subclass with equal fields:\n  %%\nConsider making the class final.", reference), reference.equals(equalSub));
        }
    }

    private void checkRedefinedSubclass() {
        if (this.typeIsFinal || this.redefinedSubclass == null) {
            return;
        }
        if (this.methodIsFinal("equals", Object.class)) {
            Assert.fail(Formatter.of("Subclass: %% has a final equals method.\nNo need to supply a redefined subclass.", this.type.getSimpleName()));
        }
        ObjectAccessor<T> referenceAccessor = this.classAccessor.getRedAccessor();
        T reference = referenceAccessor.get();
        T redefinedSub = referenceAccessor.copyIntoSubclass(this.redefinedSubclass);
        Assert.assertFalse(Formatter.of("Subclass:\n  %%\nequals subclass instance\n  %%", reference, redefinedSub), reference.equals(redefinedSub));
    }

    private void checkFinalEqualsMethod() {
        if (this.typeIsFinal || this.redefinedSubclass != null) {
            return;
        }
        boolean equalsIsFinal = this.methodIsFinal("equals", Object.class);
        boolean hashCodeIsFinal = this.methodIsFinal("hashCode", new Class[0]);
        if (this.config.isUsingGetClass()) {
            Assert.assertEquals(Formatter.of("Finality: equals and hashCode must both be final or both be non-final.", new Object[0]), equalsIsFinal, hashCodeIsFinal);
        } else {
            Assert.assertTrue(Formatter.of("Subclass: equals is not final.\nSupply an instance of a redefined subclass using withRedefinedSubclass if equals cannot be final.", new Object[0]), equalsIsFinal);
            Assert.assertTrue(Formatter.of("Subclass: hashCode is not final.\nSupply an instance of a redefined subclass using withRedefinedSubclass if hashCode cannot be final.", new Object[0]), hashCodeIsFinal);
        }
    }

    private boolean methodIsFinal(String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = this.type.getMethod(methodName, parameterTypes);
            return Modifier.isFinal(method.getModifiers());
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)("Security error: cannot access equals method for class " + this.type));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Impossible: class " + this.type + " has no equals method."));
        }
    }
}

