/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import nl.jqno.equalsverifier.AbstractDelegationChecker;
import nl.jqno.equalsverifier.CachedHashCodeChecker;
import nl.jqno.equalsverifier.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.ExamplesChecker;
import nl.jqno.equalsverifier.FieldsChecker;
import nl.jqno.equalsverifier.HierarchyChecker;
import nl.jqno.equalsverifier.JavaApiPrefabValues;
import nl.jqno.equalsverifier.NullChecker;
import nl.jqno.equalsverifier.PreconditionChecker;
import nl.jqno.equalsverifier.SignatureChecker;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.util.ClassAccessor;
import nl.jqno.equalsverifier.util.FieldIterable;
import nl.jqno.equalsverifier.util.Formatter;
import nl.jqno.equalsverifier.util.PrefabValues;
import nl.jqno.equalsverifier.util.exceptions.InternalException;

public final class EqualsVerifier<T> {
    private final List<T> equalExamples;
    private final List<T> unequalExamples;
    private Configuration<T> config;

    public static <T> EqualsVerifier<T> forClass(Class<T> type) {
        ArrayList equalExamples = new ArrayList();
        ArrayList unequalExamples = new ArrayList();
        return new EqualsVerifier<T>(type, equalExamples, unequalExamples);
    }

    public static <T> EqualsVerifier<T> forExamples(T first, T second, T ... more) {
        ArrayList equalExamples = new ArrayList();
        List<T> unequalExamples = EqualsVerifier.buildListOfAtLeastTwo(first, second, more);
        if (EqualsVerifier.listContainsDuplicates(unequalExamples)) {
            throw new IllegalArgumentException("Two objects are equal to each other.");
        }
        Class<?> type = first.getClass();
        return new EqualsVerifier(type, equalExamples, unequalExamples);
    }

    public static <T> RelaxedEqualsVerifierHelper<T> forRelaxedEqualExamples(T first, T second, T ... more) {
        List<T> examples = EqualsVerifier.buildListOfAtLeastTwo(first, second, more);
        Class<?> type = first.getClass();
        return new RelaxedEqualsVerifierHelper(type, examples);
    }

    private EqualsVerifier(Class<T> type, List<T> equalExamples, List<T> unequalExamples) {
        this.config = Configuration.of(type);
        this.equalExamples = equalExamples;
        this.unequalExamples = unequalExamples;
        JavaApiPrefabValues.addTo(this.config.getPrefabValues());
    }

    public EqualsVerifier<T> suppress(Warning ... warnings) {
        EnumSet<Warning> ws = this.config.getWarningsToSuppress();
        for (Warning warning : warnings) {
            ws.add(warning);
        }
        this.config = this.config.withWarningsToSuppress(ws);
        return this;
    }

    public <S> EqualsVerifier<T> withPrefabValues(Class<S> otherType, S red, S black) {
        if (otherType == null) {
            throw new NullPointerException("Type is null");
        }
        if (red == null || black == null) {
            throw new NullPointerException("One or both values are null.");
        }
        if (red.equals(black)) {
            throw new IllegalArgumentException("Both values are equal.");
        }
        this.config.getPrefabValues().put(otherType, red, black);
        return this;
    }

    public EqualsVerifier<T> usingGetClass() {
        this.config = this.config.withUsingGetClass();
        return this;
    }

    public EqualsVerifier<T> allFieldsShouldBeUsed() {
        this.config = this.config.withAllFieldsShouldBeUsed();
        return this;
    }

    public EqualsVerifier<T> allFieldsShouldBeUsedExcept(String ... fields) {
        this.config = this.config.withAllFieldsShouldBeUsed();
        this.config = this.config.withAllFieldsShouldBeUsedExceptions(fields);
        HashSet<String> actualFieldNames = new HashSet<String>();
        for (Field field : FieldIterable.of(this.config.getType())) {
            actualFieldNames.add(field.getName());
        }
        for (String string : this.config.getAllFieldsShouldBeUsedExceptions()) {
            if (actualFieldNames.contains(string)) continue;
            throw new IllegalArgumentException("Class " + this.config.getType().getSimpleName() + " does not contain field " + string + ".");
        }
        return this;
    }

    public EqualsVerifier<T> withRedefinedSuperclass() {
        this.config = this.config.withRedefinedSuperclass();
        return this;
    }

    public EqualsVerifier<T> withRedefinedSubclass(Class<? extends T> redefinedSubclass) {
        this.config = this.config.withRedefinedSubclass(redefinedSubclass);
        return this;
    }

    public EqualsVerifier<T> withCachedHashCode(String cachedHashCodeField, String calculateHashCodeMethod, T example) {
        CachedHashCodeInitializer<T> cachedHashCodeInitializer = new CachedHashCodeInitializer<T>(this.config.getType(), cachedHashCodeField, calculateHashCodeMethod, example);
        this.config = this.config.withCachedHashCodeInitializer(cachedHashCodeInitializer);
        return this;
    }

    @Deprecated
    public EqualsVerifier<T> debug() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() {
        PrefabValues prefabValues = this.config.getPrefabValues();
        try {
            prefabValues.backupToStash(this.config.getType());
            this.performVerification();
        }
        catch (InternalException e) {
            this.handleError(e, e.getCause());
        }
        catch (Throwable e) {
            this.handleError(e, e);
        }
        finally {
            prefabValues.restoreFromStash();
        }
    }

    private void handleError(Throwable messageContainer, Throwable trueCause) {
        boolean showCauseExceptionInMessage = trueCause != null && trueCause.equals(messageContainer);
        Formatter message = Formatter.of("%%%%\nFor more information, go to: http://www.jqno.nl/equalsverifier/errormessages", showCauseExceptionInMessage ? trueCause.getClass().getName() + ": " : "", messageContainer.getMessage() == null ? "" : messageContainer.getMessage());
        AssertionError error = new AssertionError((Object)message.format());
        ((Throwable)((Object)error)).initCause(trueCause);
        throw error;
    }

    private void performVerification() {
        if (this.config.getType().isEnum()) {
            return;
        }
        this.verifyWithoutExamples();
        this.ensureUnequalExamples();
        this.verifyWithExamples();
    }

    private void verifyWithoutExamples() {
        SignatureChecker<T> signatureChecker = new SignatureChecker<T>(this.config);
        AbstractDelegationChecker<T> abstractDelegationChecker = new AbstractDelegationChecker<T>(this.config);
        NullChecker<T> nullChecker = new NullChecker<T>(this.config);
        CachedHashCodeChecker<T> cachedHashCodeChecker = new CachedHashCodeChecker<T>(this.config);
        signatureChecker.check();
        abstractDelegationChecker.check();
        nullChecker.check();
        cachedHashCodeChecker.check();
    }

    private void ensureUnequalExamples() {
        if (this.unequalExamples.size() > 0) {
            return;
        }
        ClassAccessor<T> classAccessor = this.config.createClassAccessor();
        this.unequalExamples.add(classAccessor.getRedObject());
        this.unequalExamples.add(classAccessor.getBlackObject());
    }

    private void verifyWithExamples() {
        PreconditionChecker<T> preconditionChecker = new PreconditionChecker<T>(this.config, this.equalExamples, this.unequalExamples);
        ExamplesChecker<T> examplesChecker = new ExamplesChecker<T>(this.config, this.equalExamples, this.unequalExamples);
        HierarchyChecker<T> hierarchyChecker = new HierarchyChecker<T>(this.config);
        FieldsChecker<T> fieldsChecker = new FieldsChecker<T>(this.config);
        preconditionChecker.check();
        examplesChecker.check();
        hierarchyChecker.check();
        fieldsChecker.check();
    }

    private static <T> List<T> buildListOfAtLeastOne(T first, T ... more) {
        if (first == null) {
            throw new IllegalArgumentException("First example is null.");
        }
        ArrayList<T> result = new ArrayList<T>();
        result.add(first);
        EqualsVerifier.addArrayElementsToList(result, more);
        return result;
    }

    private static <T> List<T> buildListOfAtLeastTwo(T first, T second, T ... more) {
        if (first == null) {
            throw new IllegalArgumentException("First example is null.");
        }
        if (second == null) {
            throw new IllegalArgumentException("Second example is null.");
        }
        ArrayList<T> result = new ArrayList<T>();
        result.add(first);
        result.add(second);
        EqualsVerifier.addArrayElementsToList(result, more);
        return result;
    }

    private static <T> void addArrayElementsToList(List<T> list, T ... more) {
        if (more != null) {
            for (T e : more) {
                if (e == null) {
                    throw new IllegalArgumentException("One of the examples is null.");
                }
                list.add(e);
            }
        }
    }

    private static <T> boolean listContainsDuplicates(List<T> list) {
        return list.size() != new HashSet<T>(list).size();
    }

    public static class RelaxedEqualsVerifierHelper<T> {
        private final Class<T> type;
        private final List<T> equalExamples;

        private RelaxedEqualsVerifierHelper(Class<T> type, List<T> examples) {
            this.type = type;
            this.equalExamples = examples;
        }

        public EqualsVerifier<T> andUnequalExample(T example) {
            return this.andUnequalExamples(example, new Object[0]);
        }

        public EqualsVerifier<T> andUnequalExamples(T first, T ... more) {
            List unequalExamples = EqualsVerifier.buildListOfAtLeastOne(first, more);
            if (EqualsVerifier.listContainsDuplicates(unequalExamples)) {
                throw new IllegalArgumentException("Two objects are equal to each other.");
            }
            for (Object example : unequalExamples) {
                if (!this.equalExamples.contains(example)) continue;
                throw new IllegalArgumentException("An equal example also appears as unequal example.");
            }
            return new EqualsVerifier(this.type, this.equalExamples, unequalExamples);
        }
    }
}

