/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import nl.jqno.equalsverifier.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.util.ClassAccessor;
import nl.jqno.equalsverifier.util.PrefabValues;

public class Configuration<T> {
    private final Class<T> type;
    private final PrefabValues prefabValues;
    private final boolean allFieldsShouldBeUsed;
    private final Set<String> allFieldsShouldBeUsedExceptions;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;
    private final boolean hasRedefinedSuperclass;
    private final Class<? extends T> redefinedSubclass;
    private final boolean usingGetClass;
    private final EnumSet<Warning> warningsToSuppress;

    private Configuration(Class<T> type, PrefabValues prefabValues, boolean allFieldsShouldBeUsed, Set<String> allFieldsShouldBeUsedExceptions, CachedHashCodeInitializer<T> cachedHashCodeInitializer, boolean hasRedefinedSuperclass, Class<? extends T> redefinedSubclass, boolean usingGetClass, EnumSet<Warning> warningsToSuppress) {
        this.type = type;
        this.prefabValues = prefabValues;
        this.allFieldsShouldBeUsed = allFieldsShouldBeUsed;
        this.allFieldsShouldBeUsedExceptions = allFieldsShouldBeUsedExceptions;
        this.cachedHashCodeInitializer = cachedHashCodeInitializer;
        this.hasRedefinedSuperclass = hasRedefinedSuperclass;
        this.redefinedSubclass = redefinedSubclass;
        this.usingGetClass = usingGetClass;
        this.warningsToSuppress = warningsToSuppress;
    }

    public static <T> Configuration<T> of(Class<T> type) {
        return new Configuration<T>(type, new PrefabValues(), false, new HashSet<String>(), CachedHashCodeInitializer.passthrough(), false, null, false, EnumSet.noneOf(Warning.class));
    }

    public Class<T> getType() {
        return this.type;
    }

    public PrefabValues getPrefabValues() {
        return this.prefabValues;
    }

    public Configuration<T> withAllFieldsShouldBeUsed() {
        return new Configuration<T>(this.type, this.prefabValues, true, this.allFieldsShouldBeUsedExceptions, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public boolean isAllFieldsShouldBeUsed() {
        return this.allFieldsShouldBeUsed;
    }

    public Configuration<T> withAllFieldsShouldBeUsedExceptions(String[] value) {
        return new Configuration<T>(this.type, this.prefabValues, this.allFieldsShouldBeUsed, new HashSet<String>(Arrays.asList(value)), this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public Set<String> getAllFieldsShouldBeUsedExceptions() {
        return Collections.unmodifiableSet(this.allFieldsShouldBeUsedExceptions);
    }

    public Configuration<T> withCachedHashCodeInitializer(CachedHashCodeInitializer<T> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.allFieldsShouldBeUsed, this.allFieldsShouldBeUsedExceptions, value, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public CachedHashCodeInitializer<T> getCachedHashCodeInitializer() {
        return this.cachedHashCodeInitializer;
    }

    public Configuration<T> withRedefinedSuperclass() {
        return new Configuration<T>(this.type, this.prefabValues, this.allFieldsShouldBeUsed, this.allFieldsShouldBeUsedExceptions, this.cachedHashCodeInitializer, true, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public boolean hasRedefinedSuperclass() {
        return this.hasRedefinedSuperclass;
    }

    public Configuration<T> withRedefinedSubclass(Class<? extends T> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.allFieldsShouldBeUsed, this.allFieldsShouldBeUsedExceptions, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, value, this.usingGetClass, this.warningsToSuppress);
    }

    public Class<? extends T> getRedefinedSubclass() {
        return this.redefinedSubclass;
    }

    public Configuration<T> withUsingGetClass() {
        return new Configuration<T>(this.type, this.prefabValues, this.allFieldsShouldBeUsed, this.allFieldsShouldBeUsedExceptions, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, true, this.warningsToSuppress);
    }

    public boolean isUsingGetClass() {
        return this.usingGetClass;
    }

    public Configuration<T> withWarningsToSuppress(EnumSet<Warning> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.allFieldsShouldBeUsed, this.allFieldsShouldBeUsedExceptions, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, value);
    }

    public EnumSet<Warning> getWarningsToSuppress() {
        return EnumSet.copyOf(this.warningsToSuppress);
    }

    public ClassAccessor<T> createClassAccessor() {
        return ClassAccessor.of(this.type, this.prefabValues, this.warningsToSuppress.contains((Object)Warning.ANNOTATION));
    }
}

