/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.util.FieldIterable;
import nl.jqno.equalsverifier.util.exceptions.ReflectionException;

class CachedHashCodeInitializer<T> {
    private final boolean passthrough;
    private final Field cachedHashCodeField;
    private final Method calculateMethod;
    private final T example;

    private CachedHashCodeInitializer() {
        this.passthrough = true;
        this.cachedHashCodeField = null;
        this.calculateMethod = null;
        this.example = null;
    }

    public CachedHashCodeInitializer(Class<?> type, String cachedHashCodeField, String calculateHashCodeMethod, T example) {
        this.passthrough = false;
        this.cachedHashCodeField = this.findCachedHashCodeField(type, cachedHashCodeField);
        this.calculateMethod = this.findCalculateHashCodeMethod(type, calculateHashCodeMethod);
        this.example = example;
    }

    public static <T> CachedHashCodeInitializer<T> passthrough() {
        return new CachedHashCodeInitializer<T>();
    }

    public boolean isPassthrough() {
        return this.passthrough;
    }

    public T getExample() {
        return this.example;
    }

    public String getCachedHashCodeFieldName() {
        if (this.isPassthrough()) {
            return null;
        }
        return this.cachedHashCodeField.getName();
    }

    public int getInitializedHashCode(Object object) {
        if (!this.passthrough) {
            this.recomputeCachedHashCode(object);
        }
        return object.hashCode();
    }

    private void recomputeCachedHashCode(Object object) {
        try {
            this.cachedHashCodeField.set(object, 0);
            Integer recomputedHashCode = (Integer)this.calculateMethod.invoke(object, new Object[0]);
            this.cachedHashCodeField.set(object, recomputedHashCode);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    private Field findCachedHashCodeField(Class<?> type, String cachedHashCodeFieldName) {
        for (Field candidateField : FieldIterable.of(type)) {
            if (!candidateField.getName().equals(cachedHashCodeFieldName) || Modifier.isPublic(candidateField.getModifiers()) || !candidateField.getType().equals(Integer.TYPE)) continue;
            candidateField.setAccessible(true);
            return candidateField;
        }
        throw new IllegalArgumentException("Cached hashCode: Could not find cachedHashCodeField: must be 'private int " + cachedHashCodeFieldName + ";'");
    }

    private Method findCalculateHashCodeMethod(Class<?> type, String calculateHashCodeMethodName) {
        Class<?> currentClass = type;
        while (!currentClass.equals(Object.class)) {
            try {
                Method method = currentClass.getDeclaredMethod(calculateHashCodeMethodName, new Class[0]);
                if (!Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Integer.TYPE)) {
                    method.setAccessible(true);
                    return method;
                }
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            currentClass = currentClass.getSuperclass();
        }
        throw new IllegalArgumentException("Cached hashCode: Could not find calculateHashCodeMethod: must be 'private int " + calculateHashCodeMethodName + "()'");
    }
}

