/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.Checker;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.util.Assert;
import nl.jqno.equalsverifier.util.ClassAccessor;
import nl.jqno.equalsverifier.util.FieldIterable;
import nl.jqno.equalsverifier.util.Formatter;
import nl.jqno.equalsverifier.util.Instantiator;
import nl.jqno.equalsverifier.util.PrefabValues;

class AbstractDelegationChecker<T>
implements Checker {
    private final Class<T> type;
    private final PrefabValues prefabValues;
    private final ClassAccessor<T> classAccessor;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public AbstractDelegationChecker(Configuration<T> config) {
        this.type = config.getType();
        this.prefabValues = config.getPrefabValues();
        this.classAccessor = config.createClassAccessor();
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        Object copy;
        this.checkAbstractEqualsAndHashCode();
        this.checkAbstractDelegationInFields();
        Object instance = this.getRedPrefabValue(this.type);
        if (instance == null) {
            instance = this.classAccessor.getRedObject();
        }
        if ((copy = this.getBlackPrefabValue(this.type)) == null) {
            copy = this.classAccessor.getBlackObject();
        }
        this.checkAbstractDelegation(instance, copy);
        this.checkAbstractDelegationInSuper();
    }

    private void checkAbstractEqualsAndHashCode() {
        boolean equalsIsAbstract = this.classAccessor.isEqualsAbstract();
        boolean hashCodeIsAbstract = this.classAccessor.isHashCodeAbstract();
        if (equalsIsAbstract && hashCodeIsAbstract) {
            Assert.fail(Formatter.of("Abstract delegation: %%'s equals and hashCode methods are both abstract. They should be concrete.", this.type.getSimpleName()));
        } else if (equalsIsAbstract) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(this.type, true, true));
        } else if (hashCodeIsAbstract) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(this.type, false, true));
        }
    }

    private void checkAbstractDelegationInFields() {
        for (Field field : FieldIterable.of(this.type)) {
            Class<?> type = field.getType();
            Object instance = this.safelyGetInstance(type);
            Object copy = this.safelyGetInstance(type);
            if (instance == null || copy == null) continue;
            this.checkAbstractMethods(type, instance, copy, true);
        }
    }

    private void checkAbstractDelegation(T instance, T copy) {
        this.checkAbstractMethods(this.type, instance, copy, false);
    }

    private void checkAbstractDelegationInSuper() {
        Object copy;
        boolean hashCodeIsAbstract;
        Class<T> superclass = this.type.getSuperclass();
        ClassAccessor<T> superAccessor = this.classAccessor.getSuperAccessor();
        boolean equalsIsAbstract = superAccessor.isEqualsAbstract();
        if (equalsIsAbstract != (hashCodeIsAbstract = superAccessor.isHashCodeAbstract())) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(superclass, equalsIsAbstract, false));
        }
        if (equalsIsAbstract && hashCodeIsAbstract) {
            return;
        }
        Object instance = this.getRedPrefabValue(superclass);
        if (instance == null) {
            instance = superAccessor.getRedObject();
        }
        if ((copy = this.getBlackPrefabValue(this.type)) == null) {
            copy = superAccessor.getBlackObject();
        }
        this.checkAbstractMethods(superclass, instance, copy, false);
    }

    private Formatter buildSingleAbstractMethodErrorMessage(Class<?> type, boolean isEqualsAbstract, boolean bothShouldBeConcrete) {
        return Formatter.of("Abstract delegation: %%'s %% method is abstract, but %% is not.\n%%", type.getSimpleName(), isEqualsAbstract ? "equals" : "hashCode", isEqualsAbstract ? "hashCode" : "equals", bothShouldBeConcrete ? "Both should be concrete." : "Both should be either abstract or concrete.");
    }

    private <S> S getRedPrefabValue(Class<?> type) {
        if (this.prefabValues.contains(type)) {
            return (S)this.prefabValues.getRed(type);
        }
        return null;
    }

    private <S> S getBlackPrefabValue(Class<?> type) {
        if (this.prefabValues.contains(type)) {
            return (S)this.prefabValues.getBlack(type);
        }
        return null;
    }

    private Object safelyGetInstance(Class<?> type) {
        Object result = this.getRedPrefabValue(type);
        if (result != null) {
            return result;
        }
        try {
            return Instantiator.of(type).instantiate();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private <S> void checkAbstractMethods(Class<?> instanceClass, S instance, S copy, boolean prefabPossible) {
        try {
            instance.equals(copy);
        }
        catch (AbstractMethodError e) {
            Assert.fail(this.buildAbstractDelegationErrorMessage(instanceClass, prefabPossible, "equals", e.getMessage()), e);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.cachedHashCodeInitializer.getInitializedHashCode(instance);
        }
        catch (AbstractMethodError e) {
            Assert.fail(this.buildAbstractDelegationErrorMessage(instanceClass, prefabPossible, "hashCode", e.getMessage()), e);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    private Formatter buildAbstractDelegationErrorMessage(Class<?> type, boolean prefabPossible, String method, String originalMessage) {
        Formatter prefabFormatter = Formatter.of("\nAdd prefab values for %%.", type.getName());
        return Formatter.of("Abstract delegation: %%'s %% method delegates to an abstract method:\n %%%%", type.getSimpleName(), method, originalMessage, prefabPossible ? prefabFormatter.format() : "");
    }
}

