/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.modifier;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModifierOrderCheck
extends Check {
    public static final String MSG_ANNOTATION_ORDER = "annotation.order";
    public static final String MSG_MODIFIER_ORDER = "mod.order";
    private static final String[] JLS_ORDER = new String[]{"public", "protected", "private", "abstract", "static", "final", "transient", "volatile", "synchronized", "native", "strictfp", "default"};

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{5};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST error;
        ArrayList<DetailAST> mods = Lists.newArrayList();
        for (DetailAST modifier = ast.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            mods.add(modifier);
        }
        if (!mods.isEmpty() && (error = ModifierOrderCheck.checkOrderSuggestedByJls(mods)) != null) {
            if (error.getType() == 159) {
                this.log(error.getLineNo(), error.getColumnNo(), MSG_ANNOTATION_ORDER, error.getFirstChild().getText() + error.getFirstChild().getNextSibling().getText());
            } else {
                this.log(error.getLineNo(), error.getColumnNo(), MSG_MODIFIER_ORDER, error.getText());
            }
        }
    }

    private static DetailAST checkOrderSuggestedByJls(List<DetailAST> modifiers) {
        Iterator<DetailAST> iterator = modifiers.iterator();
        DetailAST modifier = ModifierOrderCheck.skipAnnotations(iterator);
        DetailAST offendingModifier = null;
        if (modifier.getType() != 159) {
            int index = 0;
            while (modifier != null && offendingModifier == null) {
                if (modifier.getType() == 159) {
                    offendingModifier = modifier;
                    break;
                }
                while (index < JLS_ORDER.length && !JLS_ORDER[index].equals(modifier.getText())) {
                    ++index;
                }
                if (index == JLS_ORDER.length) {
                    offendingModifier = modifier;
                    continue;
                }
                if (iterator.hasNext()) {
                    modifier = iterator.next();
                    continue;
                }
                modifier = null;
            }
        }
        return offendingModifier;
    }

    private static DetailAST skipAnnotations(Iterator<DetailAST> modifierIterator) {
        DetailAST modifier;
        do {
            modifier = modifierIterator.next();
        } while (modifierIterator.hasNext() && modifier.getType() == 159);
        return modifier;
    }
}

