/*
 * Decompiled with CFR 0.152.
 */
package namefinder;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlaceSelection
implements DownloadSelection {
    private JTextField searchTerm = new JTextField();
    private JButton submitSearch = new JButton(I18n.tr((String)"Search..."));
    private DefaultTableModel searchResults = new DefaultTableModel(){

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    };
    private JTable searchResultDisplay = new JTable(this.searchResults);
    private boolean updatingSelf;

    public void queryServer(final JComponent component) {
        final Cursor oldCursor = component.getCursor();
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String searchtext = PlaceSelection.this.searchTerm.getText();
                    if (searchtext.isEmpty()) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please enter a search string"));
                    } else {
                        component.setCursor(Cursor.getPredefinedCursor(3));
                        component.repaint();
                        URL url = new URL("http://gazetteer.openstreetmap.org/namefinder/search.xml?find=" + URLEncoder.encode(PlaceSelection.this.searchTerm.getText(), "UTF-8"));
                        HttpURLConnection activeConnection = (HttpURLConnection)url.openConnection();
                        activeConnection.setConnectTimeout(15000);
                        InputStream inputStream = activeConnection.getInputStream();
                        InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
                        SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new Parser());
                    }
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot read place search results from server"));
                    x.printStackTrace();
                }
                component.setCursor(oldCursor);
            }
        };
        new Thread(r).start();
    }

    public void addGui(final DownloadDialog gui) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr((String)"Enter a place name to search for:")), GBC.eol().insets(5, 5, 5, 5));
        panel.add((Component)this.searchTerm, GBC.std().fill(1).insets(5, 0, 5, 4));
        panel.add((Component)this.submitSearch, GBC.eol().insets(5, 0, 5, 5));
        Dimension btnSize = this.submitSearch.getPreferredSize();
        btnSize.setSize((double)btnSize.width, (double)btnSize.height * 0.8);
        this.submitSearch.setPreferredSize(btnSize);
        GBC c = GBC.std().fill().insets(5, 0, 5, 5);
        c.gridwidth = 2;
        JScrollPane scrollPane = new JScrollPane(this.searchResultDisplay);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        panel.add((Component)scrollPane, c);
        gui.tabpane.add((Component)panel, I18n.tr((String)"Places"));
        scrollPane.setPreferredSize(scrollPane.getPreferredSize());
        this.submitSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlaceSelection.this.queryServer((JComponent)gui);
            }
        });
        this.searchTerm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlaceSelection.this.queryServer((JComponent)gui);
            }
        });
        this.searchResults.addColumn(I18n.tr((String)"name"));
        this.searchResults.addColumn(I18n.tr((String)"type"));
        this.searchResults.addColumn(I18n.tr((String)"near"));
        this.searchResults.addColumn(I18n.tr((String)"zoom"));
        this.searchResultDisplay.getColumn(I18n.tr((String)"name")).setPreferredWidth(200);
        this.searchResultDisplay.getColumn(I18n.tr((String)"type")).setPreferredWidth(100);
        this.searchResultDisplay.getColumn(I18n.tr((String)"near")).setPreferredWidth(100);
        this.searchResultDisplay.getColumn(I18n.tr((String)"zoom")).setPreferredWidth(50);
        this.searchResultDisplay.getSelectionModel().setSelectionMode(0);
        this.searchResultDisplay.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    SearchResult sr = (SearchResult)value;
                    switch (column) {
                        case 0: {
                            this.setText(sr.name);
                            break;
                        }
                        case 1: {
                            this.setText(sr.type);
                            break;
                        }
                        case 2: {
                            this.setText(sr.nearestPlace);
                            break;
                        }
                        case 3: {
                            this.setText(Integer.toString(sr.zoom));
                        }
                    }
                    this.setToolTipText("<html>" + ((SearchResult)value).description + "</html>");
                }
                return this;
            }
        });
        this.searchResultDisplay.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                SearchResult r = null;
                try {
                    r = (SearchResult)PlaceSelection.this.searchResults.getValueAt(lse.getFirstIndex(), 0);
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (r != null) {
                    double size = 180.0 / Math.pow(2.0, r.zoom);
                    gui.minlat = r.lat - size / 2.0;
                    gui.maxlat = r.lat + size / 2.0;
                    gui.minlon = r.lon - size;
                    gui.maxlon = r.lon + size;
                    PlaceSelection.this.updatingSelf = true;
                    gui.boundingBoxChanged(null);
                    PlaceSelection.this.updatingSelf = false;
                }
            }
        });
        this.searchResultDisplay.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() <= 1 || PlaceSelection.this.searchResultDisplay.getSelectionModel().getMinSelectionIndex() > -1) {
                    // empty if block
                }
            }
        });
    }

    public void boundingBoxChanged(DownloadDialog gui) {
        if (!this.updatingSelf) {
            this.searchResultDisplay.clearSelection();
        }
    }

    private class Parser
    extends DefaultHandler {
        private SearchResult currentResult = null;
        private StringBuffer description = null;
        private int depth = 0;

        private Parser() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ++this.depth;
            try {
                String info;
                if (qName.equals("searchresults")) {
                    PlaceSelection.this.searchResults.setRowCount(0);
                } else if (qName.equals("named") && this.depth == 2) {
                    this.currentResult = new SearchResult();
                    this.currentResult.name = atts.getValue("name");
                    this.currentResult.type = atts.getValue("info");
                    this.currentResult.lat = Double.parseDouble(atts.getValue("lat"));
                    this.currentResult.lon = Double.parseDouble(atts.getValue("lon"));
                    this.currentResult.zoom = Integer.parseInt(atts.getValue("zoom"));
                    PlaceSelection.this.searchResults.addRow(new Object[]{this.currentResult, this.currentResult, this.currentResult, this.currentResult});
                } else if (qName.equals("description") && this.depth == 3) {
                    this.description = new StringBuffer();
                } else if (qName.equals("named") && this.depth == 4 && ("city".equals(info = atts.getValue("info")) || "town".equals(info) || "village".equals(info))) {
                    this.currentResult.nearestPlace = atts.getValue("name");
                }
            }
            catch (NumberFormatException x) {
                x.printStackTrace();
                throw new SAXException(x.getMessage(), x);
            }
            catch (NullPointerException x) {
                x.printStackTrace();
                throw new SAXException(I18n.tr((String)"NullPointerException. Possible some missing tags."), x);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (!qName.equals("searchresults") && qName.equals("description") && this.description != null) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (this.description != null) {
                this.description.append(data, start, length);
            }
        }
    }

    class SearchResult {
        public String name;
        public String type;
        public String nearestPlace;
        public String description;
        public double lat;
        public double lon;
        public int zoom;

        SearchResult() {
        }
    }
}

