/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public class EmptyForIteratorPadCheck
extends Check {
    public static final String WS_FOLLOWED = "ws.followed";
    public static final String WS_NOT_FOLLOWED = "ws.notFollowed";
    private static final String SEMICOLON = ";";
    private PadOption option = PadOption.NOSPACE;

    public void setOption(String optionStr) {
        try {
            this.option = PadOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + optionStr, iae);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{37};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getChildCount() == 0) {
            DetailAST semi = ast.getPreviousSibling();
            String line = this.getLines()[semi.getLineNo() - 1];
            int after = semi.getColumnNo() + 1;
            if (after < line.length()) {
                if (this.option == PadOption.NOSPACE && Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, WS_FOLLOWED, SEMICOLON);
                } else if (this.option == PadOption.SPACE && !Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, WS_NOT_FOLLOWED, SEMICOLON);
                }
            }
        }
    }
}

