/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class IllegalInstantiationCheck
extends Check {
    public static final String MSG_KEY = "instantiation.avoid";
    private static final String JAVA_LANG = "java.lang.";
    private final Set<String> illegalClasses = Sets.newHashSet();
    private String pkgName;
    private final Set<FullIdent> imports = Sets.newHashSet();
    private final Set<String> classNames = Sets.newHashSet();
    private final Set<DetailAST> instantiations = Sets.newHashSet();

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 136, 16, 14};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 136, 16};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        super.beginTree(rootAST);
        this.pkgName = null;
        this.imports.clear();
        this.instantiations.clear();
        this.classNames.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 136: {
                this.processLiteralNew(ast);
                break;
            }
            case 16: {
                this.processPackageDef(ast);
                break;
            }
            case 30: {
                this.processImport(ast);
                break;
            }
            case 14: {
                this.processClassDef(ast);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + ast);
            }
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        for (DetailAST literalNewAST : this.instantiations) {
            this.postProcessLiteralNew(literalNewAST);
        }
    }

    private void processClassDef(DetailAST ast) {
        DetailAST identToken = ast.findFirstToken(58);
        String className = identToken.getText();
        this.classNames.add(className);
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        this.imports.add(name);
    }

    private void processPackageDef(DetailAST ast) {
        DetailAST packageNameAST = ast.getLastChild().getPreviousSibling();
        FullIdent packageIdent = FullIdent.createFullIdent(packageNameAST);
        this.pkgName = packageIdent.getText();
    }

    private void processLiteralNew(DetailAST ast) {
        if (ast.getParent().getType() != 180) {
            this.instantiations.add(ast);
        }
    }

    private void postProcessLiteralNew(DetailAST newTokenAst) {
        DetailAST typeNameAst = newTokenAst.getFirstChild();
        DetailAST nameSibling = typeNameAst.getNextSibling();
        if (nameSibling.getType() == 17) {
            return;
        }
        FullIdent typeIdent = FullIdent.createFullIdent(typeNameAst);
        String typeName = typeIdent.getText();
        int lineNo = newTokenAst.getLineNo();
        int colNo = newTokenAst.getColumnNo();
        String fqClassName = this.getIllegalInstantiation(typeName);
        if (fqClassName != null) {
            this.log(lineNo, colNo, MSG_KEY, fqClassName);
        }
    }

    private String getIllegalInstantiation(String className) {
        String fullClassName = null;
        if (this.illegalClasses.contains(className)) {
            fullClassName = className;
        } else {
            String illegal;
            int pkgNameLen = this.pkgName == null ? 0 : this.pkgName.length();
            Iterator<String> iterator = this.illegalClasses.iterator();
            while (iterator.hasNext() && (fullClassName = this.isStandardClass(className, illegal = iterator.next()) || this.isSamePackage(className, pkgNameLen, illegal) ? illegal : this.checkImportStatements(className)) == null) {
            }
        }
        return fullClassName;
    }

    private String checkImportStatements(String className) {
        String illegalType = null;
        for (FullIdent importLineText : this.imports) {
            String importArg = importLineText.getText();
            if (importArg.endsWith(".*")) {
                importArg = importArg.substring(0, importArg.length() - 1) + className;
            }
            if (!CommonUtils.baseClassName(importArg).equals(className) || !this.illegalClasses.contains(importArg)) continue;
            illegalType = importArg;
            break;
        }
        return illegalType;
    }

    private boolean isSamePackage(String className, int pkgNameLen, String illegal) {
        return this.pkgName != null && className.length() == illegal.length() - pkgNameLen - 1 && illegal.charAt(pkgNameLen) == '.' && illegal.endsWith(className) && illegal.startsWith(this.pkgName);
    }

    private boolean isSamePackage(String className) {
        boolean isSamePackage = false;
        try {
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader != null) {
                String fqName = this.pkgName + "." + className;
                classLoader.loadClass(fqName);
                isSamePackage = true;
            }
        }
        catch (ClassNotFoundException ignored) {
            isSamePackage = false;
        }
        return isSamePackage;
    }

    private boolean isStandardClass(String className, String illegal) {
        if (illegal.length() - JAVA_LANG.length() == className.length() && illegal.endsWith(className) && illegal.startsWith(JAVA_LANG)) {
            boolean isSameFile = this.classNames.contains(className);
            boolean isSamePackage = this.isSamePackage(className);
            if (!isSameFile && !isSamePackage) {
                return true;
            }
        }
        return false;
    }

    public void setClasses(String names) {
        this.illegalClasses.clear();
        StringTokenizer tok = new StringTokenizer(names, ",");
        while (tok.hasMoreTokens()) {
            this.illegalClasses.add(tok.nextToken());
        }
    }
}

