/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayDeque;
import java.util.Deque;

public class DeclarationOrderCheck
extends Check {
    public static final String MSG_CONSTRUCTOR = "declaration.order.constructor";
    public static final String MSG_STATIC = "declaration.order.static";
    public static final String MSG_INSTANCE = "declaration.order.instance";
    public static final String MSG_ACCESS = "declaration.order.access";
    private static final int STATE_STATIC_VARIABLE_DEF = 1;
    private static final int STATE_INSTANCE_VARIABLE_DEF = 2;
    private static final int STATE_CTOR_DEF = 3;
    private static final int STATE_METHOD_DEF = 4;
    private final Deque<ScopeState> scopeStates = new ArrayDeque<ScopeState>();
    private boolean ignoreConstructors;
    private boolean ignoreModifiers;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 5, 6};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        int parentType = ast.getParent().getType();
        switch (ast.getType()) {
            case 6: {
                this.scopeStates.push(new ScopeState());
                break;
            }
            case 5: {
                if (parentType != 10 || ast.getParent().getParent().getType() != 6) break;
                this.processModifiers(ast);
                break;
            }
            case 8: {
                if (parentType != 6) break;
                this.processConstructor(ast);
                break;
            }
            case 9: {
                if (parentType != 6) break;
                ScopeState state = this.scopeStates.peek();
                state.currentScopeState = 4;
                break;
            }
        }
    }

    private void processConstructor(DetailAST ast) {
        ScopeState state = this.scopeStates.peek();
        if (state.currentScopeState > 3) {
            if (!this.ignoreConstructors) {
                this.log(ast, MSG_CONSTRUCTOR, new Object[0]);
            }
        } else {
            state.currentScopeState = 3;
        }
    }

    private void processModifiers(DetailAST ast) {
        ScopeState state = this.scopeStates.peek();
        if (ast.findFirstToken(64) == null) {
            if (state.currentScopeState > 2) {
                this.log(ast, MSG_INSTANCE, new Object[0]);
            } else if (state.currentScopeState == 1) {
                state.declarationAccess = Scope.PUBLIC;
                state.currentScopeState = 2;
            }
        } else if (state.currentScopeState > 1) {
            if (!this.ignoreModifiers || state.currentScopeState > 2) {
                this.log(ast, MSG_STATIC, new Object[0]);
            }
        } else {
            state.currentScopeState = 1;
        }
        Scope access = ScopeUtils.getScopeFromMods(ast);
        if (state.declarationAccess.compareTo(access) > 0) {
            if (!this.ignoreModifiers) {
                this.log(ast, MSG_ACCESS, new Object[0]);
            }
        } else {
            state.declarationAccess = access;
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 6) {
            this.scopeStates.pop();
        }
    }

    public void setIgnoreConstructors(boolean ignoreConstructors) {
        this.ignoreConstructors = ignoreConstructors;
    }

    public void setIgnoreModifiers(boolean ignoreModifiers) {
        this.ignoreModifiers = ignoreModifiers;
    }

    private static class ScopeState {
        private int currentScopeState = 1;
        private Scope declarationAccess = Scope.PUBLIC;

        private ScopeState() {
        }
    }
}

