/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class OneStatementPerLineCheck
extends Check {
    public static final String MSG_KEY = "multiple.statements.line";
    private int lastStatementEnd = -1;
    private int forStatementEnd = -1;
    private boolean inForHeader;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{45, 35, 37};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.inForHeader = false;
        this.lastStatementEnd = -1;
        this.forStatementEnd = -1;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 45: {
                DetailAST currentStatement = ast;
                if (OneStatementPerLineCheck.isMultilineStatement(currentStatement)) {
                    currentStatement = ast.getPreviousSibling();
                }
                if (!OneStatementPerLineCheck.isOnTheSameLine(currentStatement, this.lastStatementEnd, this.forStatementEnd) || this.inForHeader) break;
                this.log(ast, MSG_KEY, new Object[0]);
                break;
            }
            case 37: {
                this.forStatementEnd = ast.getLineNo();
                break;
            }
            default: {
                this.inForHeader = true;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 45: {
                this.lastStatementEnd = ast.getLineNo();
                this.forStatementEnd = -1;
                break;
            }
            case 37: {
                this.inForHeader = false;
                break;
            }
        }
    }

    private static boolean isOnTheSameLine(DetailAST ast, int lastStatementEnd, int forStatementEnd) {
        return lastStatementEnd == ast.getLineNo() && forStatementEnd != ast.getLineNo();
    }

    private static boolean isMultilineStatement(DetailAST ast) {
        DetailAST prevSibling;
        boolean multiline = ast.getPreviousSibling() == null ? false : (prevSibling = ast.getPreviousSibling()).getLineNo() != ast.getLineNo() && ast.getParent() != null;
        return multiline;
    }
}

