/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class UnclosedWays
extends Test {
    Bag<Way, Way> _errorWays;

    public UnclosedWays() {
        super(I18n.tr((String)"Unclosed Ways."), I18n.tr((String)"This test if ways which should be circular are closed."));
    }

    public void startTest() {
        this._errorWays = new Bag();
    }

    public void endTest() {
        this._errorWays = null;
    }

    public void visit(Way w) {
        LatLon e;
        LatLon s;
        boolean force = false;
        String type = null;
        if (w.deleted || w.incomplete) {
            return;
        }
        String test = w.get("natural");
        if (test != null) {
            type = I18n.tr((String)"natural type {0}", (Object[])new Object[]{I18n.tr((String)test)});
        }
        if ((test = w.get("landuse")) != null) {
            type = I18n.tr((String)"landuse type {0}", (Object[])new Object[]{I18n.tr((String)test)});
        }
        if ((test = w.get("junction")) != null && test.equals("roundabout")) {
            force = true;
            type = I18n.tr((String)"junction type {0}", (Object[])new Object[]{I18n.tr((String)test)});
        }
        if ((test = w.get("building")) != null && ("true".equalsIgnoreCase(test) || "yes".equalsIgnoreCase(test) || "1".equals(test))) {
            force = true;
            type = I18n.tr((String)"building");
        }
        if ((test = w.get("area")) != null && ("true".equalsIgnoreCase(test) || "yes".equalsIgnoreCase(test) || "1".equals(test))) {
            force = true;
            type = I18n.tr((String)"area");
        }
        if (type != null && (s = ((Node)w.nodes.get((int)0)).coor) != (e = ((Node)w.nodes.get((int)(w.nodes.size() - 1))).coor) && (force || s.greatCircleDistance(e) < 10000.0)) {
            ArrayList<Way> primitives = new ArrayList<Way>();
            primitives.add(w);
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Unclosed way: {0}", (Object[])new Object[]{type}), primitives));
            this._errorWays.add(w, w);
        }
    }
}

