/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.tests.ChangePropertyKeyCommand;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheck
extends Test {
    public static final String SPELLCHECK_DATA_FILE = "http://svn.openstreetmap.org/applications/utils/planet.osm/java/speller/words.cfg";
    protected static Map<String, String> spellCheckKeyData;
    protected static Bag<String, String> spellCheckValueData;
    protected static final String PREFIX;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_SOURCES;
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    protected boolean checkKeys = false;
    protected boolean checkValues = false;
    protected boolean checkFixmes = false;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JButton addSrcButton;
    protected JButton editSrcButton;
    protected JButton deleteSrcButton;
    protected static int EMPTY_VALUES;
    protected static int INVALID_KEY;
    protected static int INVALID_VALUE;
    protected static int FIXME;
    protected JList spellcheckSources;
    protected boolean testKeysBeforeUpload;
    protected boolean testValuesBeforeUpload;
    protected boolean testFixmesBeforeUpload;

    public SpellCheck() {
        super(I18n.tr((String)"Properties checker."), I18n.tr((String)"This plugin checks for errors in property keys and values."));
    }

    public static void initialize(OSMValidatorPlugin plugin) throws Exception {
        SpellCheck.initializeSpellCheck();
        SpellCheck.initializePresets();
    }

    private static void initializeSpellCheck() throws FileNotFoundException, IOException {
        spellCheckKeyData = new HashMap<String, String>();
        String sources = Main.pref.get(PREF_SOURCES);
        if (sources == null || sources.length() == 0) {
            sources = SPELLCHECK_DATA_FILE;
        }
        StringTokenizer st = new StringTokenizer(sources, ";");
        StringBuilder errorSources = new StringBuilder();
        while (st.hasMoreTokens()) {
            String line;
            String source = st.nextToken();
            File sourceFile = Util.mirror(new URL(source), Util.getPluginDir(), -1L);
            if (sourceFile == null || !sourceFile.exists()) {
                errorSources.append(source).append("\n");
                continue;
            }
            BufferedReader reader = new BufferedReader(new FileReader(sourceFile));
            String okValue = null;
            while ((line = reader.readLine()) != null && line.length() != 0) {
                if (line.startsWith("#")) continue;
                if (line.charAt(0) == '+') {
                    okValue = line.substring(1);
                    continue;
                }
                if (line.charAt(0) == '-' && okValue != null) {
                    spellCheckKeyData.put(line.substring(1), okValue);
                    continue;
                }
                System.err.println("Invalid spellcheck line:" + line);
            }
        }
        if (errorSources.length() > 0) {
            throw new IOException(I18n.tr((String)"Could not download spellcheck data file:\n {0}", (Object[])new Object[]{errorSources}));
        }
    }

    public static void initializePresets() throws Exception {
        if (!Main.pref.getBoolean(PREF_CHECK_VALUES)) {
            return;
        }
        Collection presets = TaggingPresetPreference.taggingPresets;
        if (presets == null || presets.isEmpty()) {
            return;
        }
        spellCheckValueData = new Bag();
        SpellCheck.readPresetFromPreferences();
    }

    @Override
    public void visit(Node n) {
        this.checkPrimitive((OsmPrimitive)n);
    }

    @Override
    public void visit(Way w) {
        this.checkPrimitive((OsmPrimitive)w);
    }

    private void checkPrimitive(OsmPrimitive p) {
        Bag<OsmPrimitive, String> withErrors = new Bag<OsmPrimitive, String>();
        Map props = p.keys == null ? Collections.emptyMap() : p.keys;
        for (Map.Entry prop : props.entrySet()) {
            List<String> values;
            String key = (String)prop.getKey();
            String value = (String)prop.getValue();
            if (this.checkValues && (value == null || value.trim().length() == 0) && !withErrors.contains(p, "EV")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Tags with empty values"), p, EMPTY_VALUES));
                withErrors.add(p, "EV");
            }
            if (this.checkKeys && spellCheckKeyData.containsKey(key) && !withErrors.contains(p, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Invalid property key ''{0}''", (Object[])new Object[]{key}), p, INVALID_KEY));
                withErrors.add(p, "IPK");
            }
            if (this.checkKeys && key.indexOf(" ") >= 0 && !withErrors.contains(p, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Invalid white space in property key ''{0}''", (Object[])new Object[]{key}), p, INVALID_KEY));
                withErrors.add(p, "IPK");
            }
            if (this.checkValues && value != null && (value.startsWith(" ") || value.endsWith(" ")) && !withErrors.contains(p, "SPACE")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Property values start or end with white space"), p, INVALID_VALUE));
                withErrors.add(p, "SPACE");
            }
            if (this.checkValues && value != null && value.length() > 0 && spellCheckValueData != null && (values = spellCheckValueData.get(key)) != null && !values.contains(prop.getValue()) && !withErrors.contains(p, "UPV")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Unknown property values"), p, INVALID_VALUE));
                withErrors.add(p, "UPV");
            }
            if (!this.checkFixmes || value == null || value.length() <= 0 || !value.contains("FIXME") && !value.contains("check and delete") && !key.contains("todo") && !key.contains("fixme") || withErrors.contains(p, "FIXME")) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"FIXMES"), p, FIXME));
            withErrors.add(p, "FIXME");
        }
    }

    public static void readPresets(InputStream inStream) throws SAXException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            in = new BufferedReader(new InputStreamReader(inStream));
        }
        XmlObjectParser parser = new XmlObjectParser();
        parser.mapOnStart("item", TaggingPreset.class);
        parser.map("text", TaggingPreset.Text.class);
        parser.map("check", TaggingPreset.Check.class);
        parser.map("combo", TaggingPreset.Combo.class);
        parser.map("label", TaggingPreset.Label.class);
        parser.map("key", TaggingPreset.Key.class);
        parser.start((Reader)in);
        while (parser.hasNext()) {
            Object obj = parser.next();
            if (!(obj instanceof TaggingPreset.Combo)) continue;
            TaggingPreset.Combo combo = (TaggingPreset.Combo)obj;
            for (String value : combo.values.split(",")) {
                spellCheckValueData.add(combo.key, value);
            }
        }
    }

    public static void readPresetFromPreferences() {
        String allAnnotations = Main.pref.get("taggingpreset.sources");
        StringTokenizer st = new StringTokenizer(allAnnotations, ";");
        while (st.hasMoreTokens()) {
            InputStream in = null;
            String source = st.nextToken();
            try {
                in = source.startsWith("http") || source.startsWith("ftp") || source.startsWith("file") ? new URL(source).openStream() : (source.startsWith("resource://") ? Main.class.getResourceAsStream(source.substring("resource:/".length())) : new FileInputStream(source));
                SpellCheck.readPresets(in);
                in.close();
            }
            catch (IOException e) {
            }
            catch (SAXException e) {}
        }
    }

    @Override
    public void startTest() {
        this.checkKeys = Main.pref.getBoolean(PREF_CHECK_KEYS);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Main.pref.getBoolean(PREF_CHECK_VALUES);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkFixmes = Main.pref.getBoolean(PREF_CHECK_FIXMES);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        if (this.checkKeys || this.checkValues) {
            super.visit(selection);
        }
    }

    @Override
    public void addGui(JPanel testPanel) {
        testPanel.add((Component)new JLabel(this.name), GBC.eol().insets(35, 0, 0, 0));
        boolean checkKeys = Main.pref.getBoolean(PREF_CHECK_KEYS, true);
        this.prefCheckKeys = new JCheckBox(I18n.tr((String)"Check property keys."), checkKeys);
        this.prefCheckKeys.setToolTipText(I18n.tr((String)"Validate that property keys are valid checking against list of words."));
        testPanel.add((Component)this.prefCheckKeys, GBC.std().insets(40, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckKeysBeforeUpload, GBC.eop().insets(20, 0, 0, 0));
        this.spellcheckSources = new JList(new DefaultListModel());
        if (!Main.pref.hasKey(PREF_SOURCES)) {
            Main.pref.put(PREF_SOURCES, SPELLCHECK_DATA_FILE);
        }
        String sources = Main.pref.get(PREF_SOURCES);
        StringTokenizer st = new StringTokenizer(sources, ";");
        while (st.hasMoreTokens()) {
            ((DefaultListModel)this.spellcheckSources.getModel()).addElement(st.nextToken());
        }
        this.addSrcButton = new JButton(I18n.tr((String)"Add"));
        this.addSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String source = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Spellcheck source"));
                if (source == null) {
                    return;
                }
                ((DefaultListModel)SpellCheck.this.spellcheckSources.getModel()).addElement(source);
            }
        });
        this.editSrcButton = new JButton(I18n.tr((String)"Edit"));
        this.editSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SpellCheck.this.spellcheckSources.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the row to edit."));
                } else {
                    String source = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"Spellcheck source"), SpellCheck.this.spellcheckSources.getSelectedValue());
                    if (source == null) {
                        return;
                    }
                    ((DefaultListModel)SpellCheck.this.spellcheckSources.getModel()).setElementAt(source, SpellCheck.this.spellcheckSources.getSelectedIndex());
                }
            }
        });
        this.deleteSrcButton = new JButton(I18n.tr((String)"Delete"));
        this.deleteSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SpellCheck.this.spellcheckSources.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the row to delete."));
                } else {
                    ((DefaultListModel)SpellCheck.this.spellcheckSources.getModel()).remove(SpellCheck.this.spellcheckSources.getSelectedIndex());
                }
            }
        });
        this.spellcheckSources.setVisibleRowCount(3);
        this.spellcheckSources.setToolTipText(I18n.tr((String)"The sources (url or filename) of spell check data files. See http://wiki.openstreetmap.org/index.php/User:JLS/speller for help."));
        this.addSrcButton.setToolTipText(I18n.tr((String)"Add a new spellcheck source to the list."));
        this.editSrcButton.setToolTipText(I18n.tr((String)"Edit the selected source."));
        this.deleteSrcButton.setToolTipText(I18n.tr((String)"Delete the selected source from the list."));
        testPanel.add((Component)new JLabel(I18n.tr((String)"Spellcheck data sources")), GBC.eol().insets(40, 0, 0, 0));
        testPanel.add((Component)new JScrollPane(this.spellcheckSources), GBC.eol().insets(40, 0, 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        testPanel.add((Component)buttonPanel, GBC.eol().fill(2));
        buttonPanel.add((Component)this.addSrcButton, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)this.editSrcButton, GBC.std().insets(5, 5, 5, 0));
        buttonPanel.add((Component)this.deleteSrcButton, GBC.std().insets(0, 5, 0, 0));
        ActionListener disableCheckKeysActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = SpellCheck.this.prefCheckKeys.isSelected() || SpellCheck.this.prefCheckKeysBeforeUpload.isSelected();
                SpellCheck.this.spellcheckSources.setEnabled(selected);
                SpellCheck.this.addSrcButton.setEnabled(selected);
                SpellCheck.this.editSrcButton.setEnabled(selected);
                SpellCheck.this.deleteSrcButton.setEnabled(selected);
            }
        };
        this.prefCheckKeys.addActionListener(disableCheckKeysActionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(disableCheckKeysActionListener);
        this.spellcheckSources.setEnabled(checkKeys);
        buttonPanel.setEnabled(checkKeys);
        boolean checkValues = Main.pref.getBoolean(PREF_CHECK_VALUES, true);
        this.prefCheckValues = new JCheckBox(I18n.tr((String)"Check property values."), checkValues);
        this.prefCheckValues.setToolTipText(I18n.tr((String)"Validate that property values are valid checking against presets."));
        testPanel.add((Component)this.prefCheckValues, GBC.std().insets(40, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckValuesBeforeUpload, GBC.eop().insets(20, 0, 0, 0));
        boolean checkFixmes = Main.pref.getBoolean(PREF_CHECK_FIXMES, true);
        this.prefCheckFixmes = new JCheckBox(I18n.tr((String)"Check for FIXMES."), checkFixmes);
        this.prefCheckFixmes.setToolTipText(I18n.tr((String)"Looks for nodes or ways with FIXME in any property value."));
        testPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(40, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckFixmesBeforeUpload, GBC.eop().insets(20, 0, 0, 0));
    }

    @Override
    public void ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected();
        Main.pref.put(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Main.pref.put(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Main.pref.put(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        String sources = "";
        if (this.spellcheckSources.getModel().getSize() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.spellcheckSources.getModel().getSize(); ++i) {
                sb.append(";" + this.spellcheckSources.getModel().getElementAt(i));
            }
            sources = sb.substring(1);
        }
        Main.pref.put(PREF_SOURCES, sources);
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Object> commands = new ArrayList<Object>(50);
        int i = -1;
        List<? extends OsmPrimitive> primitives = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : primitives) {
            ++i;
            Map tags = osmPrimitive.keys;
            if (tags == null || tags.size() == 0) continue;
            for (Map.Entry prop : tags.entrySet()) {
                String key = (String)prop.getKey();
                String value = (String)prop.getValue();
                if (value == null || value.trim().length() == 0) {
                    commands.add(new ChangePropertyCommand(Collections.singleton(primitives.get(i)), key, null));
                    continue;
                }
                String replacementKey = spellCheckKeyData.get(key);
                if (replacementKey == null) continue;
                commands.add((Object)new ChangePropertyKeyCommand(Collections.singleton(primitives.get(i)), key, replacementKey));
            }
        }
        if (commands.size() == 0) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand("Fix properties", commands);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof SpellCheck) {
            int code = testError.getInternalCode();
            return code == INVALID_KEY || code == EMPTY_VALUES;
        }
        return false;
    }

    static {
        PREFIX = "validator." + SpellCheck.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_SOURCES = PREFIX + ".sources";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREFIX + ".checkKeysBeforeUpload";
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREFIX + ".checkValuesBeforeUpload";
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREFIX + ".checkFixmesBeforeUpload";
        EMPTY_VALUES = 0;
        INVALID_KEY = 1;
        INVALID_VALUE = 2;
        FIXME = 3;
    }
}

