/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class OverlappingWays
extends Test {
    Bag<Pair<Node, Node>, WaySegment> nodePairs;

    public OverlappingWays() {
        super(I18n.tr((String)"Overlapping ways."), I18n.tr((String)"This test checks that a connection between two nodes is not used by more than one way."));
    }

    public void startTest() {
        this.nodePairs = new Bag(1000);
    }

    public void endTest() {
        HashMap ways_seen = new HashMap(500);
        for (List duplicated : this.nodePairs.values()) {
            int ways = duplicated.size();
            if (ways <= 1) continue;
            ArrayList<Way> prims = new ArrayList<Way>();
            ArrayList<Way> current_ways = new ArrayList<Way>();
            int highway = 0;
            int railway = 0;
            int area = 0;
            for (WaySegment ws : duplicated) {
                if (ws.way.get("highway") != null) {
                    ++highway;
                } else if (ws.way.get("railway") != null) {
                    ++railway;
                }
                String ar = ws.way.get("area");
                if (ar != null && ("true".equalsIgnoreCase(ar) || "yes".equalsIgnoreCase(ar) || "1".equals(ar))) {
                    ++area;
                }
                if (ws.way.get("landuse") != null) {
                    ++area;
                    --ways;
                }
                prims.add(ws.way);
                current_ways.add(ws.way);
            }
            List highlight = (List)ways_seen.get(current_ways);
            if (highlight == null) {
                String errortype = area > 0 ? (highway == ways ? I18n.tr((String)"Overlapping highways (with area)") : (railway == ways ? I18n.tr((String)"Overlapping railways (with area)") : I18n.tr((String)"Overlapping ways (with area)"))) : (highway == ways ? I18n.tr((String)"Overlapping highways") : (railway == ways ? I18n.tr((String)"Overlapping railways") : I18n.tr((String)"Overlapping ways")));
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)errortype), prims, duplicated));
                ways_seen.put(current_ways, duplicated);
                continue;
            }
            for (WaySegment ws : duplicated) {
                highlight.add(ws);
            }
        }
        this.nodePairs = null;
    }

    public void visit(Way w) {
        Node lastN = null;
        int i = -2;
        for (Node n : w.nodes) {
            ++i;
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.nodePairs.add((Pair<Node, Node>)Pair.sort((Pair)new Pair((Object)lastN, (Object)n)), new WaySegment(w, i));
            lastN = n;
        }
    }
}

