/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.WrapOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class OperatorWrapCheck
extends AbstractOptionCheck<WrapOption> {
    public static final String LINE_NEW = "line.new";
    public static final String LINE_PREVIOUS = "line.previous";

    public OperatorWrapCheck() {
        super(WrapOption.NL, WrapOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{109, 82, 116, 115, 127, 125, 126, 60, 128, 123, 124, 120, 118, 122, 119, 117, 113, 112, 110, 114, 111, 174, 121};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{109, 82, 116, 115, 127, 125, 126, 60, 128, 123, 124, 120, 118, 122, 119, 117, 113, 112, 110, 114, 111, 121, 174, 80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST parent;
        if (ast.getType() == 82 && ((parent = ast.getParent()).getType() == 94 || parent.getType() == 93)) {
            return;
        }
        WrapOption wOp = (WrapOption)((Object)this.getAbstractOption());
        String text = ast.getText();
        int colNo = ast.getColumnNo();
        int lineNo = ast.getLineNo();
        String currentLine = this.getLine(lineNo - 1);
        if (wOp == WrapOption.NL && !text.equals(currentLine.trim()) && StringUtils.isBlank(currentLine.substring(colNo + text.length()))) {
            this.log(lineNo, colNo, LINE_NEW, text);
        } else if (wOp == WrapOption.EOL && CommonUtils.hasWhitespaceBefore(colNo - 1, currentLine)) {
            this.log(lineNo, colNo, LINE_PREVIOUS, text);
        }
    }
}

