/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodCallHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.NewHandler;

public class LambdaHandler
extends AbstractExpressionHandler {
    public LambdaHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "lambda", ast, parent);
    }

    @Override
    public IndentLevel suggestedChildLevel(AbstractExpressionHandler child) {
        return this.getLevel();
    }

    @Override
    protected IndentLevel getLevelImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            return this.getParent().suggestedChildLevel(this);
        }
        DetailAST parent = this.getMainAst().getParent();
        if (this.getParent() instanceof NewHandler) {
            parent = parent.getParent();
        }
        IndentLevel level = new IndentLevel(this.getLineStart(parent));
        DetailAST firstChild = this.getMainAst().getFirstChild();
        if (this.getLineStart(firstChild) == firstChild.getColumnNo()) {
            level = new IndentLevel(level, this.getIndentCheck().getLineWrappingIndentation());
        }
        return level;
    }

    @Override
    public void checkIndentation() {
        IndentLevel level;
        DetailAST firstChild = this.getMainAst().getFirstChild();
        if (this.getLineStart(firstChild) == firstChild.getColumnNo() && !(level = this.getLevel()).isAcceptable(firstChild.getColumnNo())) {
            this.logError(firstChild, "arguments", firstChild.getColumnNo(), level);
        }
        if (this.getLineStart(this.getMainAst()) == this.getMainAst().getColumnNo() && !(level = new IndentLevel(this.getLevel(), this.getIndentCheck().getLineWrappingIndentation())).isAcceptable(this.getMainAst().getColumnNo())) {
            this.logError(this.getMainAst(), "", this.getMainAst().getColumnNo(), level);
        }
    }
}

