/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderStateDelegator;
import org.lobobrowser.html.style.WordInfo;

public class FontSizeRenderState
extends RenderStateDelegator {
    private final float fontSize;
    private final int fontStyle;
    private Font iFont;
    private FontMetrics iFontMetrics;
    Map iWordInfoMap = null;

    public FontSizeRenderState(RenderState prevRenderState, float fontSize, int fontStyle) {
        super(prevRenderState);
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
    }

    public FontSizeRenderState(RenderState prevRenderState, float fontSize) {
        super(prevRenderState);
        this.fontSize = fontSize;
        this.fontStyle = 0;
    }

    public Font getFont() {
        Font f = this.iFont;
        if (f != null) {
            return f;
        }
        Font parentFont = this.delegate.getFont();
        f = parentFont.deriveFont(this.fontSize);
        this.iFont = f = f.deriveFont(this.fontStyle | f.getStyle());
        return f;
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fm = this.iFontMetrics;
        if (fm == null) {
            this.iFontMetrics = fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return fm;
    }

    public void invalidate() {
        this.delegate.invalidate();
        this.iFont = null;
        this.iFontMetrics = null;
        Map map = this.iWordInfoMap;
        if (map != null) {
            map.clear();
        }
    }

    public final WordInfo getWordInfo(String word) {
        FontMetrics fm;
        WordInfo wi;
        HashMap<String, WordInfo> map = this.iWordInfoMap;
        if (map == null) {
            this.iWordInfoMap = map = new HashMap<String, WordInfo>(1);
        }
        if ((wi = (WordInfo)map.get(word)) != null) {
            return wi;
        }
        wi = new WordInfo();
        wi.fontMetrics = fm = this.getFontMetrics();
        wi.ascentPlusLeading = fm.getAscent() + fm.getLeading();
        wi.descent = fm.getDescent();
        wi.height = fm.getHeight();
        wi.width = fm.stringWidth(word);
        map.put(word, wi);
        return wi;
    }
}

