/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import javax.swing.JCheckBox;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;

class InputCheckboxControl
extends BaseInputControl {
    private final JCheckBox widget;

    public InputCheckboxControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JCheckBox checkBox = new JCheckBox();
        checkBox.setOpaque(false);
        this.widget = checkBox;
        String checkedText = this.controlElement.getAttribute("checked");
        checkBox.setSelected("checked".equalsIgnoreCase(checkedText));
        this.add(checkBox);
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
    }

    public void click() {
        this.widget.doClick();
    }

    public boolean getChecked() {
        return this.widget.isSelected();
    }

    public void setChecked(boolean checked) {
        this.widget.setSelected(checked);
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    public void resetInput() {
        String checkedText = this.controlElement.getAttribute("checked");
        this.widget.setSelected("checked".equalsIgnoreCase(checkedText));
    }

    public String getValue() {
        return this.controlElement.getAttribute("value");
    }
}

