/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static Scope getScopeFromMods(DetailAST aMods) {
        Scope retVal = Scope.PACKAGE;
        for (AST token = aMods.getFirstChild(); token != null && retVal == Scope.PACKAGE; token = token.getNextSibling()) {
            if ("public".equals(token.getText())) {
                retVal = Scope.PUBLIC;
                continue;
            }
            if ("protected".equals(token.getText())) {
                retVal = Scope.PROTECTED;
                continue;
            }
            if (!"private".equals(token.getText())) continue;
            retVal = Scope.PRIVATE;
        }
        return retVal;
    }

    public static Scope getSurroundingScope(DetailAST aAST) {
        Scope retVal = null;
        for (DetailAST token = aAST.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type == 14 || type == 15 || type == 157 || type == 154) {
                DetailAST mods = token.findFirstToken(5);
                Scope modScope = ScopeUtils.getScopeFromMods(mods);
                if (retVal != null && !retVal.isIn(modScope)) continue;
                retVal = modScope;
                continue;
            }
            if (type != 136) continue;
            retVal = Scope.ANONINNER;
            break;
        }
        return retVal;
    }

    public static boolean isInInterfaceBlock(DetailAST aAST) {
        boolean retVal = false;
        for (DetailAST token = aAST.getParent(); token != null && !retVal; token = token.getParent()) {
            int type = token.getType();
            if (type == 15) {
                retVal = true;
                continue;
            }
            if (type == 14 || type == 154 || type == 157 || type == 136) break;
        }
        return retVal;
    }

    public static boolean isInAnnotationBlock(DetailAST aAST) {
        boolean retVal = false;
        for (DetailAST token = aAST.getParent(); token != null && !retVal; token = token.getParent()) {
            int type = token.getType();
            if (type == 157) {
                retVal = true;
                continue;
            }
            if (type == 14 || type == 154 || type == 15 || type == 136) break;
        }
        return retVal;
    }

    public static boolean isInInterfaceOrAnnotationBlock(DetailAST aAST) {
        return ScopeUtils.isInInterfaceBlock(aAST) || ScopeUtils.isInAnnotationBlock(aAST);
    }

    public static boolean isInEnumBlock(DetailAST aAST) {
        boolean retVal = false;
        for (DetailAST token = aAST.getParent(); token != null && !retVal; token = token.getParent()) {
            int type = token.getType();
            if (type == 154) {
                retVal = true;
                continue;
            }
            if (type == 15 || type == 157 || type == 14 || type == 136) break;
        }
        return retVal;
    }

    public static boolean isInCodeBlock(DetailAST aAST) {
        boolean retVal = false;
        for (DetailAST token = aAST.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type != 9 && type != 8 && type != 11 && type != 12) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static boolean isOuterMostType(DetailAST aAST) {
        boolean retVal = true;
        for (DetailAST parent = aAST.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 14 && parent.getType() != 15 && parent.getType() != 157 && parent.getType() != 154) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    public static boolean isLocalVariableDef(DetailAST aAST) {
        DetailAST parent;
        boolean localVariableDef = false;
        if (aAST.getType() == 10) {
            parent = aAST.getParent();
            int type = parent.getType();
            boolean bl = localVariableDef = type == 7 || type == 35 || type == 156;
        }
        if (aAST.getType() == 21) {
            parent = aAST.getParent();
            localVariableDef = parent.getType() == 96;
        }
        return localVariableDef;
    }
}

