/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.Grabber;
import wmsplugin.Help_WMSmenuAction;
import wmsplugin.Map_Rectifier_WMSmenuAction;
import wmsplugin.OSGBGrabber;
import wmsplugin.WMSAdjustAction;
import wmsplugin.WMSDownloadAction;
import wmsplugin.WMSGrabber;
import wmsplugin.WMSInfo;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPreferenceEditor;

public class WMSPlugin
extends Plugin {
    WMSLayer wmsLayer;
    static JMenu wmsJMenu;
    static ArrayList<WMSInfo> wmsList;
    private static boolean menuEnabled;

    public WMSPlugin() {
        WMSPlugin.refreshMenu();
    }

    public static void refreshMenu() {
        wmsList.clear();
        Map prefs = Main.pref.getAllPrefix("wmsplugin.url.");
        TreeSet keys = new TreeSet(prefs.keySet());
        int prefid = 0;
        String name = null;
        String url = null;
        int lastid = -1;
        for (String key : keys) {
            String[] elements = key.split("\\.");
            if (elements.length != 4) continue;
            try {
                prefid = Integer.parseInt(elements[2]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (prefid != lastid) {
                if (name != null && url != null) {
                    wmsList.add(new WMSInfo(name, url, prefid));
                }
                name = null;
                url = null;
                lastid = prefid;
            }
            if (elements[3].equals("name")) {
                name = (String)prefs.get(key);
                continue;
            }
            if (!elements[3].equals("url")) continue;
            url = (String)prefs.get(key);
        }
        if (name != null && url != null) {
            wmsList.add(new WMSInfo(name, url, prefid));
        }
        if (wmsList.isEmpty()) {
            WMSInfo landsatInfo = new WMSInfo(I18n.tr((String)"Landsat"), "http://onearth.jpl.nasa.gov/wms.cgi?request=GetMap&layers=global_mosaic&styles=&srs=EPSG:4326&format=image/jpeg", 1);
            landsatInfo.save();
            wmsList.add(landsatInfo);
            WMSInfo npeInfo = new WMSInfo(I18n.tr((String)"NPE Maps"), "http://nick.dev.openstreetmap.org/openpaths/freemap.php?layers=npe&", 2);
            npeInfo.save();
            wmsList.add(npeInfo);
        }
        MainMenu menu = Main.main.menu;
        if (wmsJMenu == null) {
            wmsJMenu = new JMenu(I18n.tr((String)"WMS"));
            wmsJMenu.setMnemonic(87);
            menu.add((Component)wmsJMenu, 5);
        } else {
            wmsJMenu.removeAll();
        }
        for (WMSInfo u : wmsList) {
            wmsJMenu.add(new JMenuItem((Action)((Object)new WMSDownloadAction(u))));
        }
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Map_Rectifier_WMSmenuAction())));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"Blank Layer"), "blankmenu", I18n.tr((String)"Open a blank WMS layer to load data from a file"), 0, 0, false){

            public void actionPerformed(ActionEvent ev) {
                Main.main.addLayer((Layer)new WMSLayer());
            }
        }));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Help_WMSmenuAction())));
        WMSPlugin.setEnabledAll(menuEnabled);
    }

    public static Grabber getGrabber(String wmsurl) {
        if (wmsurl.matches("(?i).*layers=npeoocmap.*") || wmsurl.matches("(?i).*layers=npe.*")) {
            return new OSGBGrabber(wmsurl);
        }
        return new WMSGrabber(wmsurl);
    }

    private static void setEnabledAll(boolean isEnabled) {
        for (int i = 0; i < wmsJMenu.getItemCount(); ++i) {
            JMenuItem item = wmsJMenu.getItem(i);
            if (item == null) continue;
            item.setEnabled(isEnabled);
        }
        menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            WMSPlugin.setEnabledAll(true);
            Main.map.toolBarActions.addSeparator();
            Main.map.toolBarActions.add((Component)new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
        } else if (oldFrame != null && newFrame == null) {
            WMSPlugin.setEnabledAll(false);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new WMSPreferenceEditor();
    }

    static {
        wmsList = new ArrayList();
        menuEnabled = false;
    }
}

