/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileDB {
    public static final int PRIO_HIGH = 1;
    public static final int PRIO_LOW = 2;
    private static final String OSM_TILE_SERVER = "http://tile.openstreetmap.org";
    private Vector<OsmTile> iTileQueue = new Vector();
    private Hashtable<String, OsmTile> iHashTable = new Hashtable(SlippyMapChooserPlugin.MAX_TILES_IN_DB + 50);
    private Vector<String> iTileOrder = new Vector(SlippyMapChooserPlugin.MAX_TILES_IN_DB + 50);
    private JComponent iSlippyMapChooser;
    private int[] iMaxLatValues;
    private int[] iMaxLonValues;

    public TileDB(JComponent jComponent) {
        this.iSlippyMapChooser = jComponent;
        this.iMaxLatValues = new int[20];
        this.iMaxLonValues = new int[20];
        for (int i = 0; i < 20; ++i) {
            this.iMaxLatValues[i] = OsmMercator.LatToY(-85.05112877980659, i) / 256;
            this.iMaxLonValues[i] = OsmMercator.LonToX(180.0, i) / 256;
        }
        new TileFetcherThread(this);
        new TileFetcherThread(this);
        new TileFetcherThread(this);
        new TileFetcherThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadTile(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            return;
        }
        if (this.iMaxLonValues[n] <= n2 || this.iMaxLatValues[n] <= n3) {
            return;
        }
        String string = OsmTile.key(n, n2, n3);
        OsmTile osmTile = this.iHashTable.get(string);
        if (osmTile != null) {
            if (this.iTileQueue.remove(osmTile)) {
                this.iTileQueue.add(0, osmTile);
            }
            return;
        }
        osmTile = new OsmTile(n, n2, n3);
        this.iHashTable.put(osmTile.toString(), osmTile);
        this.iTileOrder.add(0, string);
        if (n4 == 2) {
            this.iTileQueue.addElement(osmTile);
        } else if (n4 == 1) {
            this.iTileQueue.add(0, osmTile);
        } else {
            this.iTileQueue.addElement(osmTile);
        }
        if (this.iTileOrder.size() > SlippyMapChooserPlugin.MAX_TILES_IN_DB) {
            for (int i = 0; i < SlippyMapChooserPlugin.MAX_TILES_REDUCE_BY; ++i) {
                String string2 = this.iTileOrder.remove(this.iTileOrder.size() - 1);
                this.iHashTable.remove(string2);
            }
        }
        TileDB tileDB = this;
        synchronized (tileDB) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmTile getNextTile() {
        if (this.iTileQueue.size() > 0) {
            Enumeration<OsmTile> enumeration = this.iTileQueue.elements();
            while (enumeration.hasMoreElements()) {
                OsmTile osmTile = enumeration.nextElement();
                if (osmTile.getZoomlevel() != SlippyMapChooser.iZoomlevel) continue;
                return osmTile;
            }
            return this.iTileQueue.firstElement();
        }
        TileDB tileDB = this;
        synchronized (tileDB) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.iTileQueue.firstElement();
    }

    public Enumeration<OsmTile> elements() {
        return this.iHashTable.elements();
    }

    public OsmTile get(String string) {
        return this.iHashTable.get(string);
    }

    public void remove(OsmTile osmTile) {
        this.iHashTable.remove(osmTile.toString());
        this.iTileQueue.removeElement(osmTile);
    }

    public int getLoadingQueueSize() {
        return this.iTileQueue.size();
    }

    public int getCachedTilesSize() {
        return this.iHashTable.size();
    }

    class TileFetcherThread
    implements Runnable {
        private TileDB iTileDB;
        private Thread iThread;

        public TileFetcherThread(TileDB tileDB2) {
            this.iTileDB = tileDB2;
            this.iThread = new Thread(this);
            this.iThread.start();
        }

        public void run() {
            while (true) {
                OsmTile osmTile = this.iTileDB.getNextTile();
                URL uRL = null;
                try {
                    uRL = new URL(TileDB.OSM_TILE_SERVER + osmTile.getRemotePath());
                    InputStream inputStream = uRL.openStream();
                    osmTile.setImage(ImageIO.read(inputStream));
                }
                catch (MalformedURLException malformedURLException) {
                    osmTile.setImage(null);
                }
                catch (IOException iOException) {
                    osmTile.setImage(null);
                }
                catch (Exception exception) {
                    osmTile.setImage(null);
                }
                TileDB.this.iTileQueue.removeElement(osmTile);
                TileDB.this.iSlippyMapChooser.repaint();
            }
        }
    }
}

