/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.tools.I18n;

public class OsmMapControl
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener {
    private int iLastX = 0;
    private int iLastY = 0;
    private Point iStartSelectionPoint;
    private Point iEndSelectionPoint;
    private final SlippyMapChooser iSlippyMapChooser;
    private Cursor iOldCursor;
    private boolean isMovementInPlace = false;
    private SizeButton iSizeButton = null;

    public OsmMapControl(SlippyMapChooser slippyMapChooser, JPanel jPanel, SizeButton sizeButton) {
        this.iSlippyMapChooser = slippyMapChooser;
        this.iSlippyMapChooser.addMouseListener(this);
        this.iSlippyMapChooser.addMouseMotionListener(this);
        this.iSlippyMapChooser.addMouseWheelListener(this);
        String[] stringArray = new String[]{",", ".", "up", "right", "down", "left"};
        int[] nArray = new int[]{44, 46, 38, 39, 40, 37};
        if (jPanel != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                jPanel.getInputMap(2).put(KeyStroke.getKeyStroke(nArray[i], 128), "MapMover.Zoomer." + stringArray[i]);
                jPanel.getActionMap().put("MapMover.Zoomer." + stringArray[i], new ZoomerAction(stringArray[i]));
            }
        }
        this.iSizeButton = sizeButton;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = 3072;
        if ((mouseEvent.getModifiersEx() & (0x1000 | n)) == 4096) {
            this.startMovement(mouseEvent);
            int n2 = mouseEvent.getX() - this.iLastX;
            int n3 = mouseEvent.getY() - this.iLastY;
            this.iSlippyMapChooser.moveMap(-n2, -n3);
            this.iLastX = mouseEvent.getX();
            this.iLastY = mouseEvent.getY();
        } else if ((mouseEvent.getModifiersEx() & 0x400) == 1024) {
            this.iEndSelectionPoint = mouseEvent.getPoint();
            this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, mouseEvent.getPoint());
        } else {
            this.endMovement();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = 3072;
        if (mouseEvent.getButton() == 3 && (mouseEvent.getModifiersEx() & n) == 0) {
            this.startMovement(mouseEvent);
        } else if (mouseEvent.getButton() == 1 && !this.iSizeButton.hit(mouseEvent.getPoint())) {
            this.iStartSelectionPoint = mouseEvent.getPoint();
            this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, this.iEndSelectionPoint);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.endMovement();
        } else if (mouseEvent.getButton() == 1) {
            if (this.iSizeButton.hit(mouseEvent.getPoint())) {
                this.iSizeButton.toggle();
                this.iSlippyMapChooser.resizeSlippyMap();
            } else if (mouseEvent.getClickCount() == 1) {
                this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, mouseEvent.getPoint());
                this.iEndSelectionPoint = null;
                this.iStartSelectionPoint = null;
            } else if (mouseEvent.getClickCount() == 2) {
                this.iSlippyMapChooser.zoomIn(mouseEvent.getPoint());
                this.iSlippyMapChooser.centerOnScreenPoint(mouseEvent.getPoint());
            }
        }
    }

    private void startMovement(MouseEvent mouseEvent) {
        if (this.isMovementInPlace) {
            return;
        }
        this.isMovementInPlace = true;
        this.iLastX = mouseEvent.getX();
        this.iLastY = mouseEvent.getY();
        this.iOldCursor = this.iSlippyMapChooser.getCursor();
        this.iSlippyMapChooser.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void endMovement() {
        if (!this.isMovementInPlace) {
            return;
        }
        this.isMovementInPlace = false;
        if (this.iOldCursor != null) {
            this.iSlippyMapChooser.setCursor(this.iOldCursor);
        } else {
            this.iSlippyMapChooser.setCursor(Cursor.getDefaultCursor());
        }
        this.iOldCursor = null;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            this.iSlippyMapChooser.zoomIn(mouseWheelEvent.getPoint());
        } else if (n > 0) {
            this.iSlippyMapChooser.zoomOut(mouseWheelEvent.getPoint());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private final class ZoomerAction
    extends AbstractAction {
        private final String action;

        public ZoomerAction(String string) {
            this.action = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.action.equals(".") || this.action.equals(",")) {
                Point point = OsmMapControl.this.iSlippyMapChooser.getMousePosition();
                if (point == null) {
                    point = new Point((int)OsmMapControl.this.iSlippyMapChooser.getBounds().getCenterX(), (int)OsmMapControl.this.iSlippyMapChooser.getBounds().getCenterY());
                }
                MouseWheelEvent mouseWheelEvent = new MouseWheelEvent((Component)OsmMapControl.this.iSlippyMapChooser, actionEvent.getID(), actionEvent.getWhen(), actionEvent.getModifiers(), point.x, point.y, 0, false, 0, 1, this.action.equals(",") ? -1 : 1);
                OsmMapControl.this.mouseWheelMoved(mouseWheelEvent);
            } else if (this.action.equals(I18n.tr((String)"left"))) {
                OsmMapControl.this.iSlippyMapChooser.moveMap(-30, 0);
            } else if (this.action.equals("right")) {
                OsmMapControl.this.iSlippyMapChooser.moveMap(30, 0);
            } else if (this.action.equals("up")) {
                OsmMapControl.this.iSlippyMapChooser.moveMap(0, -30);
            } else if (this.action.equals("down")) {
                OsmMapControl.this.iSlippyMapChooser.moveMap(0, 30);
            }
        }
    }
}

