/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class OsmTile {
    public static final int WIDTH = 256;
    public static final int HEIGHT = 256;
    private int iX = 0;
    private int iY = 0;
    public static final int TileBackgroundColor = 15324081;
    private BufferedImage iMapImage;
    private int iZoomLevel = -1;
    private int iIndexY = -1;
    private int iIndexX = -1;
    private boolean isInvalid = false;
    private int iHash;

    public OsmTile(int n, int n2, int n3) {
        this.iZoomLevel = n;
        this.iIndexX = n2;
        this.iIndexY = n3;
        this.iX = 256 * this.iIndexX;
        this.iY = 256 * this.iIndexY;
        this.iHash = this.toString().hashCode();
    }

    public int getZoomlevel() {
        return this.iZoomLevel;
    }

    public void paint(Graphics graphics, TileDB tileDB) {
        if (this.iMapImage != null && !this.isInvalid) {
            graphics.drawImage(this.iMapImage, this.iX, this.iY, null);
        } else if (!this.isInvalid) {
            OsmTile osmTile = this.getParent(tileDB);
            if (osmTile != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                Shape shape = graphics2D.getClip();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.clipRect(this.iX, this.iY, 256, 256);
                graphics2D.scale(2.0, 2.0);
                osmTile.paint(graphics, tileDB);
                graphics2D.setTransform(affineTransform);
                graphics2D.setClip(shape);
            } else {
                graphics.setColor(Color.RED);
                graphics.drawLine(this.iX, this.iY, this.iX + 256 - 1, this.iY + 256 - 1);
                graphics.drawLine(this.iX, this.iY + 256 - 1, this.iX + 256 - 1, this.iY);
                graphics.drawRect(this.iX, this.iY, 255, 255);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.iZoomLevel) + "/" + String.valueOf(this.iIndexX) + "/" + String.valueOf(this.iIndexY);
    }

    public static String key(int n, int n2, int n3) {
        return String.valueOf(n) + "/" + String.valueOf(n2) + "/" + String.valueOf(n3);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.iMapImage = bufferedImage;
        if (this.iMapImage == null) {
            this.isInvalid = true;
        }
    }

    public String getRemotePath() {
        return "/" + this.toString() + ".png";
    }

    public OsmTile getParent(TileDB tileDB) {
        return this.iZoomLevel == 0 ? null : tileDB.get(this.parentKey());
    }

    public String parentKey() {
        return OsmTile.key(this.iZoomLevel - 1, this.iIndexX / 2, this.iIndexY / 2);
    }
}

