/*
 * Decompiled with CFR 0.152.
 */
public class OsmMercator {
    private static int TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;

    public static double radius(int n) {
        return (double)TILE_SIZE * Math.pow(2.0, n) / (Math.PI * 2);
    }

    public static int getMaxPixels(int n) {
        return (int)((double)TILE_SIZE * Math.pow(2.0, n));
    }

    public static int falseEasting(int n) {
        return OsmMercator.getMaxPixels(n) / 2;
    }

    public static int falseNorthing(int n) {
        return -1 * OsmMercator.getMaxPixels(n) / 2;
    }

    public static int LonToX(double d, int n) {
        double d2 = Math.toRadians(d);
        return (int)(OsmMercator.radius(n) * d2 + (double)OsmMercator.falseEasting(n));
    }

    public static int LatToY(double d, int n) {
        if (d < -85.05112877980659) {
            d = -85.05112877980659;
        } else if (d > 85.05112877980659) {
            d = 85.05112877980659;
        }
        double d2 = Math.toRadians(d);
        return (int)(-1.0 * (OsmMercator.radius(n) / 2.0 * Math.log((1.0 + Math.sin(d2)) / (1.0 - Math.sin(d2)))) - (double)OsmMercator.falseNorthing(n));
    }

    public static double XToLon(int n, int n2) {
        double d = (double)(n -= OsmMercator.falseEasting(n2)) / OsmMercator.radius(n2);
        double d2 = Math.toDegrees(d);
        double d3 = Math.floor((d2 + 180.0) / 360.0);
        double d4 = d2 - d3 * 360.0;
        return d4;
    }

    public static double YToLat(int n, int n2) {
        double d = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(n += OsmMercator.falseNorthing(n2)) / OsmMercator.radius(n2)));
        return -1.0 * Math.toDegrees(d);
    }
}

