/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.GeorefImage;
import wmsplugin.WMSLayer;

public class WMSAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    GeorefImage selectedImage;
    boolean mouseDown;
    EastNorth prevEastNorth;

    public WMSAdjustAction(MapFrame mapFrame) {
        super("landsatAdjust", "movelandsat", "Adjust the position of the WMS layer", mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        for (Layer layer : Main.map.mapView.getAllLayers()) {
            if (!layer.visible || !(layer instanceof WMSLayer)) continue;
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.selectedImage = ((WMSLayer)layer).findImage(this.prevEastNorth);
            if (this.selectedImage == null) continue;
            Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.selectedImage != null) {
            EastNorth eastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            if (this.selectedImage.contains(eastNorth)) {
                this.selectedImage.displace(eastNorth.east() - this.prevEastNorth.east(), eastNorth.north() - this.prevEastNorth.north());
                this.prevEastNorth = eastNorth;
            }
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.repaint();
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.selectedImage = null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

