/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.OSRef;
import uk.me.jstott.jcoord.RefEll;
import uk.me.jstott.jcoord.UTMRef;
import uk.me.jstott.jcoord.Util;

public class LatLng {
    private double lat;
    private double lng;

    public LatLng(double lat, double lng) {
        this.lat = lat;
        this.lng = lng;
    }

    public String toString() {
        return "(" + this.lat + ", " + this.lng + ")";
    }

    public OSRef toOSRef() {
        RefEll airy1830 = new RefEll(6377563.396, 6356256.909);
        double OSGB_F0 = 0.9996012717;
        double N0 = -100000.0;
        double E0 = 400000.0;
        double phi0 = Math.toRadians(49.0);
        double lambda0 = Math.toRadians(-2.0);
        double a = airy1830.getMaj();
        double b = airy1830.getMin();
        double eSquared = airy1830.getEcc();
        double phi = Math.toRadians(this.getLat());
        double lambda = Math.toRadians(this.getLng());
        double E = 0.0;
        double N = 0.0;
        double n = (a - b) / (a + b);
        double v = a * OSGB_F0 * Math.pow(1.0 - eSquared * Util.sinSquared(phi), -0.5);
        double rho = a * OSGB_F0 * (1.0 - eSquared) * Math.pow(1.0 - eSquared * Util.sinSquared(phi), -1.5);
        double etaSquared = v / rho - 1.0;
        double M = b * OSGB_F0 * ((1.0 + n + 1.25 * n * n + 1.25 * n * n * n) * (phi - phi0) - (3.0 * n + 3.0 * n * n + 2.625 * n * n * n) * Math.sin(phi - phi0) * Math.cos(phi + phi0) + (1.875 * n * n + 1.875 * n * n * n) * Math.sin(2.0 * (phi - phi0)) * Math.cos(2.0 * (phi + phi0)) - 1.4583333333333333 * n * n * n * Math.sin(3.0 * (phi - phi0)) * Math.cos(3.0 * (phi + phi0)));
        double I = M + N0;
        double II = v / 2.0 * Math.sin(phi) * Math.cos(phi);
        double III = v / 24.0 * Math.sin(phi) * Math.pow(Math.cos(phi), 3.0) * (5.0 - Util.tanSquared(phi) + 9.0 * etaSquared);
        double IIIA = v / 720.0 * Math.sin(phi) * Math.pow(Math.cos(phi), 5.0) * (61.0 - 58.0 * Util.tanSquared(phi) + Math.pow(Math.tan(phi), 4.0));
        double IV = v * Math.cos(phi);
        double V = v / 6.0 * Math.pow(Math.cos(phi), 3.0) * (v / rho - Util.tanSquared(phi));
        double VI = v / 120.0 * Math.pow(Math.cos(phi), 5.0) * (5.0 - 18.0 * Util.tanSquared(phi) + Math.pow(Math.tan(phi), 4.0) + 14.0 * etaSquared - 58.0 * Util.tanSquared(phi) * etaSquared);
        N = I + II * Math.pow(lambda - lambda0, 2.0) + III * Math.pow(lambda - lambda0, 4.0) + IIIA * Math.pow(lambda - lambda0, 6.0);
        E = E0 + IV * (lambda - lambda0) + V * Math.pow(lambda - lambda0, 3.0) + VI * Math.pow(lambda - lambda0, 5.0);
        return new OSRef(E, N);
    }

    public UTMRef toUTMRef() {
        double UTM_F0 = 0.9996;
        double a = RefEll.WGS84.getMaj();
        double eSquared = RefEll.WGS84.getEcc();
        double longitude = this.lng;
        double latitude = this.lat;
        double latitudeRad = latitude * (Math.PI / 180);
        double longitudeRad = longitude * (Math.PI / 180);
        int longitudeZone = (int)Math.floor((longitude + 180.0) / 6.0) + 1;
        if (latitude >= 56.0 && latitude < 64.0 && longitude >= 3.0 && longitude < 12.0) {
            longitudeZone = 32;
        }
        if (latitude >= 72.0 && latitude < 84.0) {
            if (longitude >= 0.0 && longitude < 9.0) {
                longitudeZone = 31;
            } else if (longitude >= 9.0 && longitude < 21.0) {
                longitudeZone = 33;
            } else if (longitude >= 21.0 && longitude < 33.0) {
                longitudeZone = 35;
            } else if (longitude >= 33.0 && longitude < 42.0) {
                longitudeZone = 37;
            }
        }
        double longitudeOrigin = (longitudeZone - 1) * 6 - 180 + 3;
        double longitudeOriginRad = longitudeOrigin * (Math.PI / 180);
        char UTMZone = UTMRef.getUTMLatitudeZoneLetter(latitude);
        double ePrimeSquared = eSquared / (1.0 - eSquared);
        double n = a / Math.sqrt(1.0 - eSquared * Math.sin(latitudeRad) * Math.sin(latitudeRad));
        double t = Math.tan(latitudeRad) * Math.tan(latitudeRad);
        double c = ePrimeSquared * Math.cos(latitudeRad) * Math.cos(latitudeRad);
        double A = Math.cos(latitudeRad) * (longitudeRad - longitudeOriginRad);
        double M = a * ((1.0 - eSquared / 4.0 - 3.0 * eSquared * eSquared / 64.0 - 5.0 * eSquared * eSquared * eSquared / 256.0) * latitudeRad - (3.0 * eSquared / 8.0 + 3.0 * eSquared * eSquared / 32.0 + 45.0 * eSquared * eSquared * eSquared / 1024.0) * Math.sin(2.0 * latitudeRad) + (15.0 * eSquared * eSquared / 256.0 + 45.0 * eSquared * eSquared * eSquared / 1024.0) * Math.sin(4.0 * latitudeRad) - 35.0 * eSquared * eSquared * eSquared / 3072.0 * Math.sin(6.0 * latitudeRad));
        double UTMEasting = UTM_F0 * n * (A + (1.0 - t + c) * Math.pow(A, 3.0) / 6.0 + (5.0 - 18.0 * t + t * t + 72.0 * c - 58.0 * ePrimeSquared) * Math.pow(A, 5.0) / 120.0) + 500000.0;
        double UTMNorthing = UTM_F0 * (M + n * Math.tan(latitudeRad) * (A * A / 2.0 + (5.0 - t + 9.0 * c + 4.0 * c * c) * Math.pow(A, 4.0) / 24.0 + (61.0 - 58.0 * t + t * t + 600.0 * c - 330.0 * ePrimeSquared) * Math.pow(A, 6.0) / 720.0));
        if (latitude < 0.0) {
            UTMNorthing += 1.0E7;
        }
        return new UTMRef(UTMEasting, UTMNorthing, UTMZone, longitudeZone);
    }

    public void toWGS84() {
        double phiB;
        double a = RefEll.AIRY_1830.getMaj();
        double eSquared = RefEll.AIRY_1830.getEcc();
        double phi = Math.toRadians(this.lat);
        double lambda = Math.toRadians(this.lng);
        double v = a / Math.sqrt(1.0 - eSquared * Util.sinSquared(phi));
        double H = 0.0;
        double x = (v + H) * Math.cos(phi) * Math.cos(lambda);
        double y = (v + H) * Math.cos(phi) * Math.sin(lambda);
        double z = ((1.0 - eSquared) * v + H) * Math.sin(phi);
        double tx = 446.448;
        double ty = -124.157;
        double tz = 542.06;
        double s = -2.04894E-5;
        double rx = Math.toRadians(4.172222E-5);
        double ry = Math.toRadians(6.861111E-5);
        double rz = Math.toRadians(2.3391666E-4);
        double xB = tx + x * (1.0 + s) + -rx * y + ry * z;
        double yB = ty + rz * x + y * (1.0 + s) + -rx * z;
        double zB = tz + -ry * x + rx * y + z * (1.0 + s);
        a = RefEll.WGS84.getMaj();
        eSquared = RefEll.WGS84.getEcc();
        double lambdaB = Math.toDegrees(Math.atan(yB / xB));
        double p = Math.sqrt(xB * xB + yB * yB);
        double phiN = Math.atan(zB / (p * (1.0 - eSquared)));
        for (int i = 1; i < 10; ++i) {
            double phiN1;
            v = a / Math.sqrt(1.0 - eSquared * Util.sinSquared(phiN));
            phiN = phiN1 = Math.atan((zB + eSquared * v * Math.sin(phiN)) / p);
        }
        this.lat = phiB = Math.toDegrees(phiN);
        this.lng = lambdaB;
    }

    public void toOSGB36() {
        double phiB;
        RefEll wgs84 = new RefEll(6378137.0, 6356752.3141);
        double a = wgs84.getMaj();
        double eSquared = wgs84.getEcc();
        double phi = Math.toRadians(this.lat);
        double lambda = Math.toRadians(this.lng);
        double v = a / Math.sqrt(1.0 - eSquared * Util.sinSquared(phi));
        double H = 0.0;
        double x = (v + H) * Math.cos(phi) * Math.cos(lambda);
        double y = (v + H) * Math.cos(phi) * Math.sin(lambda);
        double z = ((1.0 - eSquared) * v + H) * Math.sin(phi);
        double tx = -446.448;
        double ty = 124.157;
        double tz = -542.06;
        double s = 2.04894E-5;
        double rx = Math.toRadians(-4.172222E-5);
        double ry = Math.toRadians(-6.861111E-5);
        double rz = Math.toRadians(-2.3391666E-4);
        double xB = tx + x * (1.0 + s) + -rx * y + ry * z;
        double yB = ty + rz * x + y * (1.0 + s) + -rx * z;
        double zB = tz + -ry * x + rx * y + z * (1.0 + s);
        RefEll airy1830 = new RefEll(6377563.396, 6356256.909);
        a = airy1830.getMaj();
        eSquared = airy1830.getEcc();
        double lambdaB = Math.toDegrees(Math.atan(yB / xB));
        double p = Math.sqrt(xB * xB + yB * yB);
        double phiN = Math.atan(zB / (p * (1.0 - eSquared)));
        for (int i = 1; i < 10; ++i) {
            double phiN1;
            v = a / Math.sqrt(1.0 - eSquared * Util.sinSquared(phiN));
            phiN = phiN1 = Math.atan((zB + eSquared * v * Math.sin(phiN)) / p);
        }
        this.lat = phiB = Math.toDegrees(phiN);
        this.lng = lambdaB;
    }

    public double distance(LatLng ll) {
        double er = 6366.707;
        double latFrom = Math.toRadians(this.getLat());
        double latTo = Math.toRadians(ll.getLat());
        double lngFrom = Math.toRadians(this.getLng());
        double lngTo = Math.toRadians(ll.getLng());
        double d = Math.acos(Math.sin(latFrom) * Math.sin(latTo) + Math.cos(latFrom) * Math.cos(latTo) * Math.cos(lngTo - lngFrom)) * er;
        return d;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }
}

