/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.checks.regexp.MatchSuppressor;
import com.puppycrawl.tools.checkstyle.checks.regexp.NeverSuppress;
import java.util.regex.Pattern;

class DetectorOptions {
    private final int compileFlags;
    private final AbstractViolationReporter reporter;
    private String format = "$.";
    private String message = "";
    private int minimum;
    private int maximum;
    private boolean ignoreCase;
    private MatchSuppressor suppressor = NeverSuppress.INSTANCE;

    public DetectorOptions(int compileFlags, AbstractViolationReporter reporter) {
        this.compileFlags = compileFlags;
        this.reporter = reporter;
    }

    public DetectorOptions setFormat(String format) {
        this.format = format;
        return this;
    }

    public DetectorOptions setMessage(String message) {
        this.message = message;
        return this;
    }

    public DetectorOptions setMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    public DetectorOptions setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public DetectorOptions setSuppressor(MatchSuppressor sup) {
        this.suppressor = sup;
        return this;
    }

    public DetectorOptions setIgnoreCase(boolean ignore) {
        this.ignoreCase = ignore;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public AbstractViolationReporter getReporter() {
        return this.reporter;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public MatchSuppressor getSuppressor() {
        return this.suppressor;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Pattern getPattern() {
        int options = this.ignoreCase ? this.compileFlags | 2 : this.compileFlags;
        return Pattern.compile(this.format, options);
    }
}

