/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractAccessControlNameCheck;

public class ConstantNameCheck
extends AbstractAccessControlNameCheck {
    public ConstantNameCheck() {
        super("^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10};
    }

    @Override
    protected final boolean mustCheckName(DetailAST ast) {
        DetailAST nameAST;
        boolean retVal = false;
        DetailAST modifiersAST = ast.findFirstToken(5);
        boolean isStatic = modifiersAST.branchContains(64);
        boolean isFinal = modifiersAST.branchContains(39);
        if ((isStatic && isFinal && this.shouldCheckInScope(modifiersAST) || ScopeUtils.inAnnotationBlock(ast) || ScopeUtils.inInterfaceOrAnnotationBlock(ast) && !ScopeUtils.inCodeBlock(ast)) && !"serialVersionUID".equals((nameAST = ast.findFirstToken(58)).getText()) && !"serialPersistentFields".equals(nameAST.getText())) {
            retVal = true;
        }
        return retVal;
    }
}

